package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{CustomLayer, CountryCode3, MapStyle}
import scala.jdk.CollectionConverters._
final case class MapConfiguration(
    style: MapStyle,
    politicalView: Optional[CountryCode3] = Optional.Absent,
    customLayers: Optional[Iterable[CustomLayer]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.MapConfiguration = {
    import MapConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.MapConfiguration
      .builder()
      .style(MapStyle.unwrap(style): java.lang.String)
      .optionallyWith(
        politicalView.map(value => CountryCode3.unwrap(value): java.lang.String)
      )(_.politicalView)
      .optionallyWith(
        customLayers.map(value =>
          value.map { item =>
            CustomLayer.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customLayers)
      .build()
  }
  def asReadOnly: zio.aws.location.model.MapConfiguration.ReadOnly =
    zio.aws.location.model.MapConfiguration.wrap(buildAwsValue())
}
object MapConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.MapConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.MapConfiguration =
      zio.aws.location.model.MapConfiguration(
        style,
        politicalView.map(value => value),
        customLayers.map(value => value)
      )
    def style: MapStyle
    def politicalView: Optional[CountryCode3]
    def customLayers: Optional[List[CustomLayer]]
    def getStyle: ZIO[Any, Nothing, MapStyle] = ZIO.succeed(style)
    def getPoliticalView: ZIO[Any, AwsError, CountryCode3] =
      AwsError.unwrapOptionField("politicalView", politicalView)
    def getCustomLayers: ZIO[Any, AwsError, List[CustomLayer]] =
      AwsError.unwrapOptionField("customLayers", customLayers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.MapConfiguration
  ) extends zio.aws.location.model.MapConfiguration.ReadOnly {
    override val style: MapStyle =
      zio.aws.location.model.primitives.MapStyle(impl.style())
    override val politicalView: Optional[CountryCode3] = zio.aws.core.internal
      .optionalFromNullable(impl.politicalView())
      .map(value => zio.aws.location.model.primitives.CountryCode3(value))
    override val customLayers: Optional[List[CustomLayer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customLayers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.CustomLayer(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.MapConfiguration
  ): zio.aws.location.model.MapConfiguration.ReadOnly = new Wrapper(impl)
}
