package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{CustomLayer, CountryCode3OrEmpty}
import scala.jdk.CollectionConverters._
final case class MapConfigurationUpdate(
    politicalView: Optional[CountryCode3OrEmpty] = Optional.Absent,
    customLayers: Optional[Iterable[CustomLayer]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.MapConfigurationUpdate = {
    import MapConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.MapConfigurationUpdate
      .builder()
      .optionallyWith(
        politicalView.map(value =>
          CountryCode3OrEmpty.unwrap(value): java.lang.String
        )
      )(_.politicalView)
      .optionallyWith(
        customLayers.map(value =>
          value.map { item =>
            CustomLayer.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customLayers)
      .build()
  }
  def asReadOnly: zio.aws.location.model.MapConfigurationUpdate.ReadOnly =
    zio.aws.location.model.MapConfigurationUpdate.wrap(buildAwsValue())
}
object MapConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.MapConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.MapConfigurationUpdate =
      zio.aws.location.model.MapConfigurationUpdate(
        politicalView.map(value => value),
        customLayers.map(value => value)
      )
    def politicalView: Optional[CountryCode3OrEmpty]
    def customLayers: Optional[List[CustomLayer]]
    def getPoliticalView: ZIO[Any, AwsError, CountryCode3OrEmpty] =
      AwsError.unwrapOptionField("politicalView", politicalView)
    def getCustomLayers: ZIO[Any, AwsError, List[CustomLayer]] =
      AwsError.unwrapOptionField("customLayers", customLayers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.MapConfigurationUpdate
  ) extends zio.aws.location.model.MapConfigurationUpdate.ReadOnly {
    override val politicalView: Optional[CountryCode3OrEmpty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.politicalView())
        .map(value =>
          zio.aws.location.model.primitives.CountryCode3OrEmpty(value)
        )
    override val customLayers: Optional[List[CustomLayer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customLayers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.CustomLayer(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.MapConfigurationUpdate
  ): zio.aws.location.model.MapConfigurationUpdate.ReadOnly = new Wrapper(impl)
}
