package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait OptimizationMode {
  def unwrap: software.amazon.awssdk.services.location.model.OptimizationMode
}
object OptimizationMode {
  def wrap(
      value: software.amazon.awssdk.services.location.model.OptimizationMode
  ): zio.aws.location.model.OptimizationMode = value match {
    case software.amazon.awssdk.services.location.model.OptimizationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.OptimizationMode.FASTEST_ROUTE =>
      val r = FastestRoute
      r
    case software.amazon.awssdk.services.location.model.OptimizationMode.SHORTEST_ROUTE =>
      val r = ShortestRoute
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.location.model.OptimizationMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.OptimizationMode =
      software.amazon.awssdk.services.location.model.OptimizationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FastestRoute extends zio.aws.location.model.OptimizationMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.OptimizationMode =
      software.amazon.awssdk.services.location.model.OptimizationMode.FASTEST_ROUTE
  }
  case object ShortestRoute extends zio.aws.location.model.OptimizationMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.OptimizationMode =
      software.amazon.awssdk.services.location.model.OptimizationMode.SHORTEST_ROUTE
  }
}
