package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PlaceSupplementalCategory,
  PlaceCategory
}
import scala.jdk.CollectionConverters._
final case class Place(
    label: Optional[String] = Optional.Absent,
    geometry: zio.aws.location.model.PlaceGeometry,
    addressNumber: Optional[String] = Optional.Absent,
    street: Optional[String] = Optional.Absent,
    neighborhood: Optional[String] = Optional.Absent,
    municipality: Optional[String] = Optional.Absent,
    subRegion: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent,
    country: Optional[String] = Optional.Absent,
    postalCode: Optional[String] = Optional.Absent,
    interpolated: Optional[Boolean] = Optional.Absent,
    timeZone: Optional[zio.aws.location.model.TimeZone] = Optional.Absent,
    unitType: Optional[String] = Optional.Absent,
    unitNumber: Optional[String] = Optional.Absent,
    categories: Optional[Iterable[PlaceCategory]] = Optional.Absent,
    supplementalCategories: Optional[Iterable[PlaceSupplementalCategory]] =
      Optional.Absent,
    subMunicipality: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.location.model.Place = {
    import Place.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.Place
      .builder()
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .geometry(geometry.buildAwsValue())
      .optionallyWith(addressNumber.map(value => value: java.lang.String))(
        _.addressNumber
      )
      .optionallyWith(street.map(value => value: java.lang.String))(_.street)
      .optionallyWith(neighborhood.map(value => value: java.lang.String))(
        _.neighborhood
      )
      .optionallyWith(municipality.map(value => value: java.lang.String))(
        _.municipality
      )
      .optionallyWith(subRegion.map(value => value: java.lang.String))(
        _.subRegion
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(country.map(value => value: java.lang.String))(_.country)
      .optionallyWith(postalCode.map(value => value: java.lang.String))(
        _.postalCode
      )
      .optionallyWith(interpolated.map(value => value: java.lang.Boolean))(
        _.interpolated
      )
      .optionallyWith(timeZone.map(value => value.buildAwsValue()))(_.timeZone)
      .optionallyWith(unitType.map(value => value: java.lang.String))(
        _.unitType
      )
      .optionallyWith(unitNumber.map(value => value: java.lang.String))(
        _.unitNumber
      )
      .optionallyWith(
        categories.map(value =>
          value.map { item =>
            PlaceCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.categories)
      .optionallyWith(
        supplementalCategories.map(value =>
          value.map { item =>
            PlaceSupplementalCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supplementalCategories)
      .optionallyWith(subMunicipality.map(value => value: java.lang.String))(
        _.subMunicipality
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.Place.ReadOnly =
    zio.aws.location.model.Place.wrap(buildAwsValue())
}
object Place {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.Place] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.Place = zio.aws.location.model.Place(
      label.map(value => value),
      geometry.asEditable,
      addressNumber.map(value => value),
      street.map(value => value),
      neighborhood.map(value => value),
      municipality.map(value => value),
      subRegion.map(value => value),
      region.map(value => value),
      country.map(value => value),
      postalCode.map(value => value),
      interpolated.map(value => value),
      timeZone.map(value => value.asEditable),
      unitType.map(value => value),
      unitNumber.map(value => value),
      categories.map(value => value),
      supplementalCategories.map(value => value),
      subMunicipality.map(value => value)
    )
    def label: Optional[String]
    def geometry: zio.aws.location.model.PlaceGeometry.ReadOnly
    def addressNumber: Optional[String]
    def street: Optional[String]
    def neighborhood: Optional[String]
    def municipality: Optional[String]
    def subRegion: Optional[String]
    def region: Optional[String]
    def country: Optional[String]
    def postalCode: Optional[String]
    def interpolated: Optional[Boolean]
    def timeZone: Optional[zio.aws.location.model.TimeZone.ReadOnly]
    def unitType: Optional[String]
    def unitNumber: Optional[String]
    def categories: Optional[List[PlaceCategory]]
    def supplementalCategories: Optional[List[PlaceSupplementalCategory]]
    def subMunicipality: Optional[String]
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getGeometry
        : ZIO[Any, Nothing, zio.aws.location.model.PlaceGeometry.ReadOnly] =
      ZIO.succeed(geometry)
    def getAddressNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressNumber", addressNumber)
    def getStreet: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("street", street)
    def getNeighborhood: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("neighborhood", neighborhood)
    def getMunicipality: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("municipality", municipality)
    def getSubRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subRegion", subRegion)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getCountry: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("country", country)
    def getPostalCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getInterpolated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("interpolated", interpolated)
    def getTimeZone
        : ZIO[Any, AwsError, zio.aws.location.model.TimeZone.ReadOnly] =
      AwsError.unwrapOptionField("timeZone", timeZone)
    def getUnitType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unitType", unitType)
    def getUnitNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unitNumber", unitNumber)
    def getCategories: ZIO[Any, AwsError, List[PlaceCategory]] =
      AwsError.unwrapOptionField("categories", categories)
    def getSupplementalCategories
        : ZIO[Any, AwsError, List[PlaceSupplementalCategory]] = AwsError
      .unwrapOptionField("supplementalCategories", supplementalCategories)
    def getSubMunicipality: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subMunicipality", subMunicipality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.Place
  ) extends zio.aws.location.model.Place.ReadOnly {
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val geometry: zio.aws.location.model.PlaceGeometry.ReadOnly =
      zio.aws.location.model.PlaceGeometry.wrap(impl.geometry())
    override val addressNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addressNumber())
      .map(value => value: String)
    override val street: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.street())
      .map(value => value: String)
    override val neighborhood: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.neighborhood())
      .map(value => value: String)
    override val municipality: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.municipality())
      .map(value => value: String)
    override val subRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subRegion())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
    override val country: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => value: String)
    override val postalCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.postalCode())
      .map(value => value: String)
    override val interpolated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.interpolated())
      .map(value => value: Boolean)
    override val timeZone: Optional[zio.aws.location.model.TimeZone.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeZone())
        .map(value => zio.aws.location.model.TimeZone.wrap(value))
    override val unitType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.unitType())
      .map(value => value: String)
    override val unitNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.unitNumber())
      .map(value => value: String)
    override val categories: Optional[List[PlaceCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.categories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.PlaceCategory(item)
          }.toList
        )
    override val supplementalCategories
        : Optional[List[PlaceSupplementalCategory]] = zio.aws.core.internal
      .optionalFromNullable(impl.supplementalCategories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.location.model.primitives.PlaceSupplementalCategory(item)
        }.toList
      )
    override val subMunicipality: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subMunicipality())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.Place
  ): zio.aws.location.model.Place.ReadOnly = new Wrapper(impl)
}
