package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlaceGeometry(
    point: Optional[Iterable[Double]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.PlaceGeometry = {
    import PlaceGeometry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.PlaceGeometry
      .builder()
      .optionallyWith(
        point.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.point)
      .build()
  }
  def asReadOnly: zio.aws.location.model.PlaceGeometry.ReadOnly =
    zio.aws.location.model.PlaceGeometry.wrap(buildAwsValue())
}
object PlaceGeometry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.PlaceGeometry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.PlaceGeometry =
      zio.aws.location.model.PlaceGeometry(point.map(value => value))
    def point: Optional[List[Double]]
    def getPoint: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("point", point)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.PlaceGeometry
  ) extends zio.aws.location.model.PlaceGeometry.ReadOnly {
    override val point: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.point())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.PlaceGeometry
  ): zio.aws.location.model.PlaceGeometry.ReadOnly = new Wrapper(impl)
}
