package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PlaceId,
  SearchForPositionResultDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class SearchForPositionResult(
    place: zio.aws.location.model.Place,
    distance: SearchForPositionResultDistanceDouble,
    placeId: Optional[PlaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchForPositionResult = {
    import SearchForPositionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchForPositionResult
      .builder()
      .place(place.buildAwsValue())
      .distance(
        SearchForPositionResultDistanceDouble.unwrap(distance): java.lang.Double
      )
      .optionallyWith(
        placeId.map(value => PlaceId.unwrap(value): java.lang.String)
      )(_.placeId)
      .build()
  }
  def asReadOnly: zio.aws.location.model.SearchForPositionResult.ReadOnly =
    zio.aws.location.model.SearchForPositionResult.wrap(buildAwsValue())
}
object SearchForPositionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchForPositionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchForPositionResult =
      zio.aws.location.model.SearchForPositionResult(
        place.asEditable,
        distance,
        placeId.map(value => value)
      )
    def place: zio.aws.location.model.Place.ReadOnly
    def distance: SearchForPositionResultDistanceDouble
    def placeId: Optional[PlaceId]
    def getPlace: ZIO[Any, Nothing, zio.aws.location.model.Place.ReadOnly] =
      ZIO.succeed(place)
    def getDistance: ZIO[Any, Nothing, SearchForPositionResultDistanceDouble] =
      ZIO.succeed(distance)
    def getPlaceId: ZIO[Any, AwsError, PlaceId] =
      AwsError.unwrapOptionField("placeId", placeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchForPositionResult
  ) extends zio.aws.location.model.SearchForPositionResult.ReadOnly {
    override val place: zio.aws.location.model.Place.ReadOnly =
      zio.aws.location.model.Place.wrap(impl.place())
    override val distance: SearchForPositionResultDistanceDouble =
      zio.aws.location.model.primitives
        .SearchForPositionResultDistanceDouble(impl.distance())
    override val placeId: Optional[PlaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.placeId())
      .map(value => zio.aws.location.model.primitives.PlaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchForPositionResult
  ): zio.aws.location.model.SearchForPositionResult.ReadOnly = new Wrapper(impl)
}
