package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PlaceSupplementalCategory,
  PlaceCategory,
  PlaceId
}
import scala.jdk.CollectionConverters._
final case class SearchForSuggestionsResult(
    text: String,
    placeId: Optional[PlaceId] = Optional.Absent,
    categories: Optional[Iterable[PlaceCategory]] = Optional.Absent,
    supplementalCategories: Optional[Iterable[PlaceSupplementalCategory]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchForSuggestionsResult = {
    import SearchForSuggestionsResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchForSuggestionsResult
      .builder()
      .text(text: java.lang.String)
      .optionallyWith(
        placeId.map(value => PlaceId.unwrap(value): java.lang.String)
      )(_.placeId)
      .optionallyWith(
        categories.map(value =>
          value.map { item =>
            PlaceCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.categories)
      .optionallyWith(
        supplementalCategories.map(value =>
          value.map { item =>
            PlaceSupplementalCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supplementalCategories)
      .build()
  }
  def asReadOnly: zio.aws.location.model.SearchForSuggestionsResult.ReadOnly =
    zio.aws.location.model.SearchForSuggestionsResult.wrap(buildAwsValue())
}
object SearchForSuggestionsResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchForSuggestionsResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchForSuggestionsResult =
      zio.aws.location.model.SearchForSuggestionsResult(
        text,
        placeId.map(value => value),
        categories.map(value => value),
        supplementalCategories.map(value => value)
      )
    def text: String
    def placeId: Optional[PlaceId]
    def categories: Optional[List[PlaceCategory]]
    def supplementalCategories: Optional[List[PlaceSupplementalCategory]]
    def getText: ZIO[Any, Nothing, String] = ZIO.succeed(text)
    def getPlaceId: ZIO[Any, AwsError, PlaceId] =
      AwsError.unwrapOptionField("placeId", placeId)
    def getCategories: ZIO[Any, AwsError, List[PlaceCategory]] =
      AwsError.unwrapOptionField("categories", categories)
    def getSupplementalCategories
        : ZIO[Any, AwsError, List[PlaceSupplementalCategory]] = AwsError
      .unwrapOptionField("supplementalCategories", supplementalCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchForSuggestionsResult
  ) extends zio.aws.location.model.SearchForSuggestionsResult.ReadOnly {
    override val text: String = impl.text(): String
    override val placeId: Optional[PlaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.placeId())
      .map(value => zio.aws.location.model.primitives.PlaceId(value))
    override val categories: Optional[List[PlaceCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.categories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.PlaceCategory(item)
          }.toList
        )
    override val supplementalCategories
        : Optional[List[PlaceSupplementalCategory]] = zio.aws.core.internal
      .optionalFromNullable(impl.supplementalCategories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.location.model.primitives.PlaceSupplementalCategory(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchForSuggestionsResult
  ): zio.aws.location.model.SearchForSuggestionsResult.ReadOnly = new Wrapper(
    impl
  )
}
