package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PlaceId,
  SearchForTextResultRelevanceDouble,
  SearchForTextResultDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class SearchForTextResult(
    place: zio.aws.location.model.Place,
    distance: Optional[SearchForTextResultDistanceDouble] = Optional.Absent,
    relevance: Optional[SearchForTextResultRelevanceDouble] = Optional.Absent,
    placeId: Optional[PlaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchForTextResult = {
    import SearchForTextResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchForTextResult
      .builder()
      .place(place.buildAwsValue())
      .optionallyWith(
        distance.map(value =>
          SearchForTextResultDistanceDouble.unwrap(value): java.lang.Double
        )
      )(_.distance)
      .optionallyWith(
        relevance.map(value =>
          SearchForTextResultRelevanceDouble.unwrap(value): java.lang.Double
        )
      )(_.relevance)
      .optionallyWith(
        placeId.map(value => PlaceId.unwrap(value): java.lang.String)
      )(_.placeId)
      .build()
  }
  def asReadOnly: zio.aws.location.model.SearchForTextResult.ReadOnly =
    zio.aws.location.model.SearchForTextResult.wrap(buildAwsValue())
}
object SearchForTextResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchForTextResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchForTextResult =
      zio.aws.location.model.SearchForTextResult(
        place.asEditable,
        distance.map(value => value),
        relevance.map(value => value),
        placeId.map(value => value)
      )
    def place: zio.aws.location.model.Place.ReadOnly
    def distance: Optional[SearchForTextResultDistanceDouble]
    def relevance: Optional[SearchForTextResultRelevanceDouble]
    def placeId: Optional[PlaceId]
    def getPlace: ZIO[Any, Nothing, zio.aws.location.model.Place.ReadOnly] =
      ZIO.succeed(place)
    def getDistance: ZIO[Any, AwsError, SearchForTextResultDistanceDouble] =
      AwsError.unwrapOptionField("distance", distance)
    def getRelevance: ZIO[Any, AwsError, SearchForTextResultRelevanceDouble] =
      AwsError.unwrapOptionField("relevance", relevance)
    def getPlaceId: ZIO[Any, AwsError, PlaceId] =
      AwsError.unwrapOptionField("placeId", placeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchForTextResult
  ) extends zio.aws.location.model.SearchForTextResult.ReadOnly {
    override val place: zio.aws.location.model.Place.ReadOnly =
      zio.aws.location.model.Place.wrap(impl.place())
    override val distance: Optional[SearchForTextResultDistanceDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distance())
        .map(value =>
          zio.aws.location.model.primitives
            .SearchForTextResultDistanceDouble(value)
        )
    override val relevance: Optional[SearchForTextResultRelevanceDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relevance())
        .map(value =>
          zio.aws.location.model.primitives
            .SearchForTextResultRelevanceDouble(value)
        )
    override val placeId: Optional[PlaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.placeId())
      .map(value => zio.aws.location.model.primitives.PlaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchForTextResult
  ): zio.aws.location.model.SearchForTextResult.ReadOnly = new Wrapper(impl)
}
