package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ApiKey,
  LanguageTag,
  PlaceIndexSearchResultLimit,
  ResourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForPositionRequest(
    indexName: ResourceName,
    position: Iterable[Double],
    maxResults: Optional[PlaceIndexSearchResultLimit] = Optional.Absent,
    language: Optional[LanguageTag] = Optional.Absent,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest = {
    import SearchPlaceIndexForPositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value =>
          PlaceIndexSearchResultLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForPositionRequest.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForPositionRequest
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForPositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForPositionRequest =
      zio.aws.location.model.SearchPlaceIndexForPositionRequest(
        indexName,
        position,
        maxResults.map(value => value),
        language.map(value => value),
        key.map(value => value)
      )
    def indexName: ResourceName
    def position: List[Double]
    def maxResults: Optional[PlaceIndexSearchResultLimit]
    def language: Optional[LanguageTag]
    def key: Optional[ApiKey]
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
    def getMaxResults: ZIO[Any, AwsError, PlaceIndexSearchResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest
  ) extends zio.aws.location.model.SearchPlaceIndexForPositionRequest.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val maxResults: Optional[PlaceIndexSearchResultLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives.PlaceIndexSearchResultLimit(value)
        )
    override val language: Optional[LanguageTag] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest
  ): zio.aws.location.model.SearchPlaceIndexForPositionRequest.ReadOnly =
    new Wrapper(impl)
}
