package zio.aws.location.model
import zio.aws.location.model.primitives.{
  LanguageTag,
  PlaceIndexSearchResultLimit
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForPositionSummary(
    position: Iterable[Double],
    maxResults: Optional[PlaceIndexSearchResultLimit] = Optional.Absent,
    dataSource: String,
    language: Optional[LanguageTag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary = {
    import SearchPlaceIndexForPositionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary
      .builder()
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value =>
          PlaceIndexSearchResultLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForPositionSummary
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForPositionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForPositionSummary =
      zio.aws.location.model.SearchPlaceIndexForPositionSummary(
        position,
        maxResults.map(value => value),
        dataSource,
        language.map(value => value)
      )
    def position: List[Double]
    def maxResults: Optional[PlaceIndexSearchResultLimit]
    def dataSource: String
    def language: Optional[LanguageTag]
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
    def getMaxResults: ZIO[Any, AwsError, PlaceIndexSearchResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary
  ) extends zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly {
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val maxResults: Optional[PlaceIndexSearchResultLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives.PlaceIndexSearchResultLimit(value)
        )
    override val dataSource: String = impl.dataSource(): String
    override val language: Optional[LanguageTag] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary
  ): zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly =
    new Wrapper(impl)
}
