package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ApiKey,
  PlaceCategory,
  LanguageTag,
  SearchPlaceIndexForSuggestionsRequestTextString,
  SearchPlaceIndexForSuggestionsRequestMaxResultsInteger,
  ResourceName,
  CountryCode3
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForSuggestionsRequest(
    indexName: ResourceName,
    text: SearchPlaceIndexForSuggestionsRequestTextString,
    biasPosition: Optional[Iterable[Double]] = Optional.Absent,
    filterBBox: Optional[Iterable[Double]] = Optional.Absent,
    filterCountries: Optional[Iterable[CountryCode3]] = Optional.Absent,
    maxResults: Optional[
      SearchPlaceIndexForSuggestionsRequestMaxResultsInteger
    ] = Optional.Absent,
    language: Optional[LanguageTag] = Optional.Absent,
    filterCategories: Optional[Iterable[PlaceCategory]] = Optional.Absent,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest = {
    import SearchPlaceIndexForSuggestionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .text(
        SearchPlaceIndexForSuggestionsRequestTextString.unwrap(
          text
        ): java.lang.String
      )
      .optionallyWith(
        biasPosition.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.biasPosition)
      .optionallyWith(
        filterBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.filterBBox)
      .optionallyWith(
        filterCountries.map(value =>
          value.map { item =>
            CountryCode3.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCountries)
      .optionallyWith(
        maxResults.map(value =>
          SearchPlaceIndexForSuggestionsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        filterCategories.map(value =>
          value.map { item =>
            PlaceCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCategories)
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForSuggestionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest(
        indexName,
        text,
        biasPosition.map(value => value),
        filterBBox.map(value => value),
        filterCountries.map(value => value),
        maxResults.map(value => value),
        language.map(value => value),
        filterCategories.map(value => value),
        key.map(value => value)
      )
    def indexName: ResourceName
    def text: SearchPlaceIndexForSuggestionsRequestTextString
    def biasPosition: Optional[List[Double]]
    def filterBBox: Optional[List[Double]]
    def filterCountries: Optional[List[CountryCode3]]
    def maxResults
        : Optional[SearchPlaceIndexForSuggestionsRequestMaxResultsInteger]
    def language: Optional[LanguageTag]
    def filterCategories: Optional[List[PlaceCategory]]
    def key: Optional[ApiKey]
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getText
        : ZIO[Any, Nothing, SearchPlaceIndexForSuggestionsRequestTextString] =
      ZIO.succeed(text)
    def getBiasPosition: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("biasPosition", biasPosition)
    def getFilterBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("filterBBox", filterBBox)
    def getFilterCountries: ZIO[Any, AwsError, List[CountryCode3]] =
      AwsError.unwrapOptionField("filterCountries", filterCountries)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      SearchPlaceIndexForSuggestionsRequestMaxResultsInteger
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getFilterCategories: ZIO[Any, AwsError, List[PlaceCategory]] =
      AwsError.unwrapOptionField("filterCategories", filterCategories)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest
  ) extends zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val text: SearchPlaceIndexForSuggestionsRequestTextString =
      zio.aws.location.model.primitives
        .SearchPlaceIndexForSuggestionsRequestTextString(impl.text())
    override val biasPosition: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.biasPosition())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterBBox: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.filterBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterCountries: Optional[List[CountryCode3]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCountries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.CountryCode3(item)
          }.toList
        )
    override val maxResults
        : Optional[SearchPlaceIndexForSuggestionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .SearchPlaceIndexForSuggestionsRequestMaxResultsInteger(value)
        )
    override val language: Optional[LanguageTag] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val filterCategories: Optional[List[PlaceCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.PlaceCategory(item)
          }.toList
        )
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest
  ): zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest.ReadOnly =
    new Wrapper(impl)
}
