package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForSuggestionsResponse(
    summary: zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary,
    results: Iterable[zio.aws.location.model.SearchForSuggestionsResult]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse = {
    import SearchPlaceIndexForSuggestionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse
      .builder()
      .summary(summary.buildAwsValue())
      .results(results.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForSuggestionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse(
        summary.asEditable,
        results.map { item =>
          item.asEditable
        }
      )
    def summary
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly
    def results
        : List[zio.aws.location.model.SearchForSuggestionsResult.ReadOnly]
    def getSummary: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly
    ] = ZIO.succeed(summary)
    def getResults: ZIO[Any, Nothing, List[
      zio.aws.location.model.SearchForSuggestionsResult.ReadOnly
    ]] = ZIO.succeed(results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse
  ) extends zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly {
    override val summary
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary
        .wrap(impl.summary())
    override val results
        : List[zio.aws.location.model.SearchForSuggestionsResult.ReadOnly] =
      impl
        .results()
        .asScala
        .map { item =>
          zio.aws.location.model.SearchForSuggestionsResult.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse
  ): zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly =
    new Wrapper(impl)
}
