package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PlaceCategory,
  Integer,
  LanguageTag,
  SensitiveString,
  CountryCode3
}
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForSuggestionsSummary(
    text: SensitiveString,
    biasPosition: Optional[Iterable[Double]] = Optional.Absent,
    filterBBox: Optional[Iterable[Double]] = Optional.Absent,
    filterCountries: Optional[Iterable[CountryCode3]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    dataSource: String,
    language: Optional[LanguageTag] = Optional.Absent,
    filterCategories: Optional[Iterable[PlaceCategory]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary = {
    import SearchPlaceIndexForSuggestionsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
      .builder()
      .text(SensitiveString.unwrap(text): java.lang.String)
      .optionallyWith(
        biasPosition.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.biasPosition)
      .optionallyWith(
        filterBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.filterBBox)
      .optionallyWith(
        filterCountries.map(value =>
          value.map { item =>
            CountryCode3.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCountries)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        filterCategories.map(value =>
          value.map { item =>
            PlaceCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCategories)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForSuggestionsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary(
        text,
        biasPosition.map(value => value),
        filterBBox.map(value => value),
        filterCountries.map(value => value),
        maxResults.map(value => value),
        dataSource,
        language.map(value => value),
        filterCategories.map(value => value)
      )
    def text: SensitiveString
    def biasPosition: Optional[List[Double]]
    def filterBBox: Optional[List[Double]]
    def filterCountries: Optional[List[CountryCode3]]
    def maxResults: Optional[Integer]
    def dataSource: String
    def language: Optional[LanguageTag]
    def filterCategories: Optional[List[PlaceCategory]]
    def getText: ZIO[Any, Nothing, SensitiveString] = ZIO.succeed(text)
    def getBiasPosition: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("biasPosition", biasPosition)
    def getFilterBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("filterBBox", filterBBox)
    def getFilterCountries: ZIO[Any, AwsError, List[CountryCode3]] =
      AwsError.unwrapOptionField("filterCountries", filterCountries)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getFilterCategories: ZIO[Any, AwsError, List[PlaceCategory]] =
      AwsError.unwrapOptionField("filterCategories", filterCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ) extends zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly {
    override val text: SensitiveString =
      zio.aws.location.model.primitives.SensitiveString(impl.text())
    override val biasPosition: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.biasPosition())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterBBox: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.filterBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterCountries: Optional[List[CountryCode3]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCountries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.CountryCode3(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val dataSource: String = impl.dataSource(): String
    override val language: Optional[LanguageTag] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val filterCategories: Optional[List[PlaceCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.PlaceCategory(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ): zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly =
    new Wrapper(impl)
}
