package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForTextResponse(
    summary: zio.aws.location.model.SearchPlaceIndexForTextSummary,
    results: Iterable[zio.aws.location.model.SearchForTextResult]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse = {
    import SearchPlaceIndexForTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse
      .builder()
      .summary(summary.buildAwsValue())
      .results(results.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForTextResponse.wrap(buildAwsValue())
}
object SearchPlaceIndexForTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForTextResponse =
      zio.aws.location.model.SearchPlaceIndexForTextResponse(
        summary.asEditable,
        results.map { item =>
          item.asEditable
        }
      )
    def summary: zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly
    def results: List[zio.aws.location.model.SearchForTextResult.ReadOnly]
    def getSummary: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly
    ] = ZIO.succeed(summary)
    def getResults: ZIO[Any, Nothing, List[
      zio.aws.location.model.SearchForTextResult.ReadOnly
    ]] = ZIO.succeed(results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse
  ) extends zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly {
    override val summary
        : zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly =
      zio.aws.location.model.SearchPlaceIndexForTextSummary.wrap(impl.summary())
    override val results
        : List[zio.aws.location.model.SearchForTextResult.ReadOnly] = impl
      .results()
      .asScala
      .map { item =>
        zio.aws.location.model.SearchForTextResult.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse
  ): zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly =
    new Wrapper(impl)
}
