package zio.aws.location.model
import zio.aws.location.model.primitives.{
  PlaceCategory,
  LanguageTag,
  PlaceIndexSearchResultLimit,
  SensitiveString,
  CountryCode3
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForTextSummary(
    text: SensitiveString,
    biasPosition: Optional[Iterable[Double]] = Optional.Absent,
    filterBBox: Optional[Iterable[Double]] = Optional.Absent,
    filterCountries: Optional[Iterable[CountryCode3]] = Optional.Absent,
    maxResults: Optional[PlaceIndexSearchResultLimit] = Optional.Absent,
    resultBBox: Optional[Iterable[Double]] = Optional.Absent,
    dataSource: String,
    language: Optional[LanguageTag] = Optional.Absent,
    filterCategories: Optional[Iterable[PlaceCategory]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary = {
    import SearchPlaceIndexForTextSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary
      .builder()
      .text(SensitiveString.unwrap(text): java.lang.String)
      .optionallyWith(
        biasPosition.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.biasPosition)
      .optionallyWith(
        filterBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.filterBBox)
      .optionallyWith(
        filterCountries.map(value =>
          value.map { item =>
            CountryCode3.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCountries)
      .optionallyWith(
        maxResults.map(value =>
          PlaceIndexSearchResultLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        resultBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.resultBBox)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        filterCategories.map(value =>
          value.map { item =>
            PlaceCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCategories)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForTextSummary.wrap(buildAwsValue())
}
object SearchPlaceIndexForTextSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForTextSummary =
      zio.aws.location.model.SearchPlaceIndexForTextSummary(
        text,
        biasPosition.map(value => value),
        filterBBox.map(value => value),
        filterCountries.map(value => value),
        maxResults.map(value => value),
        resultBBox.map(value => value),
        dataSource,
        language.map(value => value),
        filterCategories.map(value => value)
      )
    def text: SensitiveString
    def biasPosition: Optional[List[Double]]
    def filterBBox: Optional[List[Double]]
    def filterCountries: Optional[List[CountryCode3]]
    def maxResults: Optional[PlaceIndexSearchResultLimit]
    def resultBBox: Optional[List[Double]]
    def dataSource: String
    def language: Optional[LanguageTag]
    def filterCategories: Optional[List[PlaceCategory]]
    def getText: ZIO[Any, Nothing, SensitiveString] = ZIO.succeed(text)
    def getBiasPosition: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("biasPosition", biasPosition)
    def getFilterBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("filterBBox", filterBBox)
    def getFilterCountries: ZIO[Any, AwsError, List[CountryCode3]] =
      AwsError.unwrapOptionField("filterCountries", filterCountries)
    def getMaxResults: ZIO[Any, AwsError, PlaceIndexSearchResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResultBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("resultBBox", resultBBox)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getFilterCategories: ZIO[Any, AwsError, List[PlaceCategory]] =
      AwsError.unwrapOptionField("filterCategories", filterCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary
  ) extends zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly {
    override val text: SensitiveString =
      zio.aws.location.model.primitives.SensitiveString(impl.text())
    override val biasPosition: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.biasPosition())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterBBox: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.filterBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterCountries: Optional[List[CountryCode3]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCountries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.CountryCode3(item)
          }.toList
        )
    override val maxResults: Optional[PlaceIndexSearchResultLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives.PlaceIndexSearchResultLimit(value)
        )
    override val resultBBox: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.resultBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val dataSource: String = impl.dataSource(): String
    override val language: Optional[LanguageTag] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val filterCategories: Optional[List[PlaceCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.PlaceCategory(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary
  ): zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly =
    new Wrapper(impl)
}
