package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait SpeedUnit {
  def unwrap: software.amazon.awssdk.services.location.model.SpeedUnit
}
object SpeedUnit {
  def wrap(
      value: software.amazon.awssdk.services.location.model.SpeedUnit
  ): zio.aws.location.model.SpeedUnit = value match {
    case software.amazon.awssdk.services.location.model.SpeedUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.SpeedUnit.KILOMETERS_PER_HOUR =>
      val r = KilometersPerHour
      r
    case software.amazon.awssdk.services.location.model.SpeedUnit.MILES_PER_HOUR =>
      val r = MilesPerHour
      r
  }
  case object unknownToSdkVersion extends zio.aws.location.model.SpeedUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.SpeedUnit =
      software.amazon.awssdk.services.location.model.SpeedUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object KilometersPerHour extends zio.aws.location.model.SpeedUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.SpeedUnit =
      software.amazon.awssdk.services.location.model.SpeedUnit.KILOMETERS_PER_HOUR
  }
  case object MilesPerHour extends zio.aws.location.model.SpeedUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.SpeedUnit =
      software.amazon.awssdk.services.location.model.SpeedUnit.MILES_PER_HOUR
  }
}
