package zio.aws.location.model
import zio.aws.location.model.primitives.{
  StepGeometryOffsetInteger,
  StepDurationSecondsDouble,
  StepDistanceDouble
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Step(
    startPosition: Iterable[Double],
    endPosition: Iterable[Double],
    distance: StepDistanceDouble,
    durationSeconds: StepDurationSecondsDouble,
    geometryOffset: Optional[StepGeometryOffsetInteger] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.location.model.Step = {
    import Step.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.Step
      .builder()
      .startPosition(startPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .endPosition(endPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .distance(StepDistanceDouble.unwrap(distance): java.lang.Double)
      .durationSeconds(
        StepDurationSecondsDouble.unwrap(durationSeconds): java.lang.Double
      )
      .optionallyWith(
        geometryOffset.map(value =>
          StepGeometryOffsetInteger.unwrap(value): Integer
        )
      )(_.geometryOffset)
      .build()
  }
  def asReadOnly: zio.aws.location.model.Step.ReadOnly =
    zio.aws.location.model.Step.wrap(buildAwsValue())
}
object Step {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.Step] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.Step = zio.aws.location.model.Step(
      startPosition,
      endPosition,
      distance,
      durationSeconds,
      geometryOffset.map(value => value)
    )
    def startPosition: List[Double]
    def endPosition: List[Double]
    def distance: StepDistanceDouble
    def durationSeconds: StepDurationSecondsDouble
    def geometryOffset: Optional[StepGeometryOffsetInteger]
    def getStartPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(startPosition)
    def getEndPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(endPosition)
    def getDistance: ZIO[Any, Nothing, StepDistanceDouble] =
      ZIO.succeed(distance)
    def getDurationSeconds: ZIO[Any, Nothing, StepDurationSecondsDouble] =
      ZIO.succeed(durationSeconds)
    def getGeometryOffset: ZIO[Any, AwsError, StepGeometryOffsetInteger] =
      AwsError.unwrapOptionField("geometryOffset", geometryOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.Step
  ) extends zio.aws.location.model.Step.ReadOnly {
    override val startPosition: List[Double] = impl
      .startPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val endPosition: List[Double] = impl
      .endPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val distance: StepDistanceDouble =
      zio.aws.location.model.primitives.StepDistanceDouble(impl.distance())
    override val durationSeconds: StepDurationSecondsDouble =
      zio.aws.location.model.primitives
        .StepDurationSecondsDouble(impl.durationSeconds())
    override val geometryOffset: Optional[StepGeometryOffsetInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geometryOffset())
        .map(value =>
          zio.aws.location.model.primitives.StepGeometryOffsetInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.Step
  ): zio.aws.location.model.Step.ReadOnly = new Wrapper(impl)
}
