package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrackingFilterGeometry(
    polygon: Optional[Iterable[Iterable[Iterable[Double]]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.TrackingFilterGeometry = {
    import TrackingFilterGeometry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.TrackingFilterGeometry
      .builder()
      .optionallyWith(
        polygon.map(value =>
          value.map { item =>
            item.map { item =>
              item.map { item =>
                item: java.lang.Double
              }.asJavaCollection
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.polygon)
      .build()
  }
  def asReadOnly: zio.aws.location.model.TrackingFilterGeometry.ReadOnly =
    zio.aws.location.model.TrackingFilterGeometry.wrap(buildAwsValue())
}
object TrackingFilterGeometry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.TrackingFilterGeometry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.TrackingFilterGeometry =
      zio.aws.location.model.TrackingFilterGeometry(polygon.map(value => value))
    def polygon: Optional[List[List[List[Double]]]]
    def getPolygon: ZIO[Any, AwsError, List[List[List[Double]]]] =
      AwsError.unwrapOptionField("polygon", polygon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.TrackingFilterGeometry
  ) extends zio.aws.location.model.TrackingFilterGeometry.ReadOnly {
    override val polygon: Optional[List[List[List[Double]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.polygon())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              item.asScala.map { item =>
                item: Double
              }.toList
            }.toList
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.TrackingFilterGeometry
  ): zio.aws.location.model.TrackingFilterGeometry.ReadOnly = new Wrapper(impl)
}
