package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  TruckDimensionsWidthDouble,
  TruckDimensionsHeightDouble,
  TruckDimensionsLengthDouble
}
import scala.jdk.CollectionConverters._
final case class TruckDimensions(
    length: Optional[TruckDimensionsLengthDouble] = Optional.Absent,
    height: Optional[TruckDimensionsHeightDouble] = Optional.Absent,
    width: Optional[TruckDimensionsWidthDouble] = Optional.Absent,
    unit: Optional[zio.aws.location.model.DimensionUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.TruckDimensions = {
    import TruckDimensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.TruckDimensions
      .builder()
      .optionallyWith(
        length.map(value =>
          TruckDimensionsLengthDouble.unwrap(value): java.lang.Double
        )
      )(_.length)
      .optionallyWith(
        height.map(value =>
          TruckDimensionsHeightDouble.unwrap(value): java.lang.Double
        )
      )(_.height)
      .optionallyWith(
        width.map(value =>
          TruckDimensionsWidthDouble.unwrap(value): java.lang.Double
        )
      )(_.width)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.location.model.TruckDimensions.ReadOnly =
    zio.aws.location.model.TruckDimensions.wrap(buildAwsValue())
}
object TruckDimensions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.TruckDimensions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.TruckDimensions =
      zio.aws.location.model.TruckDimensions(
        length.map(value => value),
        height.map(value => value),
        width.map(value => value),
        unit.map(value => value)
      )
    def length: Optional[TruckDimensionsLengthDouble]
    def height: Optional[TruckDimensionsHeightDouble]
    def width: Optional[TruckDimensionsWidthDouble]
    def unit: Optional[zio.aws.location.model.DimensionUnit]
    def getLength: ZIO[Any, AwsError, TruckDimensionsLengthDouble] =
      AwsError.unwrapOptionField("length", length)
    def getHeight: ZIO[Any, AwsError, TruckDimensionsHeightDouble] =
      AwsError.unwrapOptionField("height", height)
    def getWidth: ZIO[Any, AwsError, TruckDimensionsWidthDouble] =
      AwsError.unwrapOptionField("width", width)
    def getUnit: ZIO[Any, AwsError, zio.aws.location.model.DimensionUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.TruckDimensions
  ) extends zio.aws.location.model.TruckDimensions.ReadOnly {
    override val length: Optional[TruckDimensionsLengthDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.length())
        .map(value =>
          zio.aws.location.model.primitives.TruckDimensionsLengthDouble(value)
        )
    override val height: Optional[TruckDimensionsHeightDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.height())
        .map(value =>
          zio.aws.location.model.primitives.TruckDimensionsHeightDouble(value)
        )
    override val width: Optional[TruckDimensionsWidthDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.width())
        .map(value =>
          zio.aws.location.model.primitives.TruckDimensionsWidthDouble(value)
        )
    override val unit: Optional[zio.aws.location.model.DimensionUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.location.model.DimensionUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.TruckDimensions
  ): zio.aws.location.model.TruckDimensions.ReadOnly = new Wrapper(impl)
}
