package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Timestamp,
  ResourceDescription,
  ResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateKeyRequest(
    keyName: ResourceName,
    description: Optional[ResourceDescription] = Optional.Absent,
    expireTime: Optional[Timestamp] = Optional.Absent,
    noExpiry: Optional[Boolean] = Optional.Absent,
    forceUpdate: Optional[Boolean] = Optional.Absent,
    restrictions: Optional[zio.aws.location.model.ApiKeyRestrictions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateKeyRequest = {
    import UpdateKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateKeyRequest
      .builder()
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        expireTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expireTime)
      .optionallyWith(noExpiry.map(value => value: java.lang.Boolean))(
        _.noExpiry
      )
      .optionallyWith(forceUpdate.map(value => value: java.lang.Boolean))(
        _.forceUpdate
      )
      .optionallyWith(restrictions.map(value => value.buildAwsValue()))(
        _.restrictions
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateKeyRequest.ReadOnly =
    zio.aws.location.model.UpdateKeyRequest.wrap(buildAwsValue())
}
object UpdateKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateKeyRequest =
      zio.aws.location.model.UpdateKeyRequest(
        keyName,
        description.map(value => value),
        expireTime.map(value => value),
        noExpiry.map(value => value),
        forceUpdate.map(value => value),
        restrictions.map(value => value.asEditable)
      )
    def keyName: ResourceName
    def description: Optional[ResourceDescription]
    def expireTime: Optional[Timestamp]
    def noExpiry: Optional[Boolean]
    def forceUpdate: Optional[Boolean]
    def restrictions
        : Optional[zio.aws.location.model.ApiKeyRestrictions.ReadOnly]
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getExpireTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expireTime", expireTime)
    def getNoExpiry: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("noExpiry", noExpiry)
    def getForceUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceUpdate", forceUpdate)
    def getRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.ApiKeyRestrictions.ReadOnly
    ] = AwsError.unwrapOptionField("restrictions", restrictions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateKeyRequest
  ) extends zio.aws.location.model.UpdateKeyRequest.ReadOnly {
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val expireTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expireTime())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val noExpiry: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.noExpiry())
      .map(value => value: Boolean)
    override val forceUpdate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceUpdate())
      .map(value => value: Boolean)
    override val restrictions
        : Optional[zio.aws.location.model.ApiKeyRestrictions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restrictions())
        .map(value => zio.aws.location.model.ApiKeyRestrictions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateKeyRequest
  ): zio.aws.location.model.UpdateKeyRequest.ReadOnly = new Wrapper(impl)
}
