package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, Arn}
import scala.jdk.CollectionConverters._
final case class UpdateKeyResponse(
    keyArn: Arn,
    keyName: ResourceName,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateKeyResponse = {
    import UpdateKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateKeyResponse
      .builder()
      .keyArn(Arn.unwrap(keyArn): java.lang.String)
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateKeyResponse.ReadOnly =
    zio.aws.location.model.UpdateKeyResponse.wrap(buildAwsValue())
}
object UpdateKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateKeyResponse =
      zio.aws.location.model.UpdateKeyResponse(keyArn, keyName, updateTime)
    def keyArn: Arn
    def keyName: ResourceName
    def updateTime: Timestamp
    def getKeyArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(keyArn)
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateKeyResponse
  ) extends zio.aws.location.model.UpdateKeyResponse.ReadOnly {
    override val keyArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.keyArn())
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateKeyResponse
  ): zio.aws.location.model.UpdateKeyResponse.ReadOnly = new Wrapper(impl)
}
