package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{ResourceDescription, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdateMapRequest(
    mapName: ResourceName,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    configurationUpdate: Optional[
      zio.aws.location.model.MapConfigurationUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateMapRequest = {
    import UpdateMapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateMapRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(configurationUpdate.map(value => value.buildAwsValue()))(
        _.configurationUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateMapRequest.ReadOnly =
    zio.aws.location.model.UpdateMapRequest.wrap(buildAwsValue())
}
object UpdateMapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateMapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateMapRequest =
      zio.aws.location.model.UpdateMapRequest(
        mapName,
        pricingPlan.map(value => value),
        description.map(value => value),
        configurationUpdate.map(value => value.asEditable)
      )
    def mapName: ResourceName
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def description: Optional[ResourceDescription]
    def configurationUpdate
        : Optional[zio.aws.location.model.MapConfigurationUpdate.ReadOnly]
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.MapConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("configurationUpdate", configurationUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateMapRequest
  ) extends zio.aws.location.model.UpdateMapRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val configurationUpdate
        : Optional[zio.aws.location.model.MapConfigurationUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationUpdate())
        .map(value => zio.aws.location.model.MapConfigurationUpdate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateMapRequest
  ): zio.aws.location.model.UpdateMapRequest.ReadOnly = new Wrapper(impl)
}
