package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{ResourceDescription, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdatePlaceIndexRequest(
    indexName: ResourceName,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    dataSourceConfiguration: Optional[
      zio.aws.location.model.DataSourceConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest = {
    import UpdatePlaceIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        dataSourceConfiguration.map(value => value.buildAwsValue())
      )(_.dataSourceConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdatePlaceIndexRequest.ReadOnly =
    zio.aws.location.model.UpdatePlaceIndexRequest.wrap(buildAwsValue())
}
object UpdatePlaceIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdatePlaceIndexRequest =
      zio.aws.location.model.UpdatePlaceIndexRequest(
        indexName,
        pricingPlan.map(value => value),
        description.map(value => value),
        dataSourceConfiguration.map(value => value.asEditable)
      )
    def indexName: ResourceName
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def description: Optional[ResourceDescription]
    def dataSourceConfiguration
        : Optional[zio.aws.location.model.DataSourceConfiguration.ReadOnly]
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDataSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataSourceConfiguration",
      dataSourceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest
  ) extends zio.aws.location.model.UpdatePlaceIndexRequest.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val dataSourceConfiguration
        : Optional[zio.aws.location.model.DataSourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSourceConfiguration())
        .map(value =>
          zio.aws.location.model.DataSourceConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest
  ): zio.aws.location.model.UpdatePlaceIndexRequest.ReadOnly = new Wrapper(impl)
}
