package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, GeoArn, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdatePlaceIndexResponse(
    indexName: ResourceName,
    indexArn: GeoArn,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse = {
    import UpdatePlaceIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .indexArn(GeoArn.unwrap(indexArn): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly =
    zio.aws.location.model.UpdatePlaceIndexResponse.wrap(buildAwsValue())
}
object UpdatePlaceIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdatePlaceIndexResponse =
      zio.aws.location.model
        .UpdatePlaceIndexResponse(indexName, indexArn, updateTime)
    def indexName: ResourceName
    def indexArn: GeoArn
    def updateTime: Timestamp
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getIndexArn: ZIO[Any, Nothing, GeoArn] = ZIO.succeed(indexArn)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse
  ) extends zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val indexArn: GeoArn =
      zio.aws.location.model.primitives.GeoArn(impl.indexArn())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse
  ): zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
