package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{ResourceDescription, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdateRouteCalculatorRequest(
    calculatorName: ResourceName,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest = {
    import UpdateRouteCalculatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateRouteCalculatorRequest.ReadOnly =
    zio.aws.location.model.UpdateRouteCalculatorRequest.wrap(buildAwsValue())
}
object UpdateRouteCalculatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateRouteCalculatorRequest =
      zio.aws.location.model.UpdateRouteCalculatorRequest(
        calculatorName,
        pricingPlan.map(value => value),
        description.map(value => value)
      )
    def calculatorName: ResourceName
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def description: Optional[ResourceDescription]
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest
  ) extends zio.aws.location.model.UpdateRouteCalculatorRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest
  ): zio.aws.location.model.UpdateRouteCalculatorRequest.ReadOnly = new Wrapper(
    impl
  )
}
