package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{ResourceDescription, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdateTrackerRequest(
    trackerName: ResourceName,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    pricingPlanDataSource: Optional[String] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    positionFiltering: Optional[zio.aws.location.model.PositionFiltering] =
      Optional.Absent,
    eventBridgeEnabled: Optional[Boolean] = Optional.Absent,
    kmsKeyEnableGeospatialQueries: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateTrackerRequest = {
    import UpdateTrackerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateTrackerRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(positionFiltering.map(value => value.unwrap))(
        _.positionFiltering
      )
      .optionallyWith(
        eventBridgeEnabled.map(value => value: java.lang.Boolean)
      )(_.eventBridgeEnabled)
      .optionallyWith(
        kmsKeyEnableGeospatialQueries.map(value => value: java.lang.Boolean)
      )(_.kmsKeyEnableGeospatialQueries)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateTrackerRequest.ReadOnly =
    zio.aws.location.model.UpdateTrackerRequest.wrap(buildAwsValue())
}
object UpdateTrackerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateTrackerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateTrackerRequest =
      zio.aws.location.model.UpdateTrackerRequest(
        trackerName,
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        description.map(value => value),
        positionFiltering.map(value => value),
        eventBridgeEnabled.map(value => value),
        kmsKeyEnableGeospatialQueries.map(value => value)
      )
    def trackerName: ResourceName
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Optional[String]
    def description: Optional[ResourceDescription]
    def positionFiltering: Optional[zio.aws.location.model.PositionFiltering]
    def eventBridgeEnabled: Optional[Boolean]
    def kmsKeyEnableGeospatialQueries: Optional[Boolean]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPositionFiltering
        : ZIO[Any, AwsError, zio.aws.location.model.PositionFiltering] =
      AwsError.unwrapOptionField("positionFiltering", positionFiltering)
    def getEventBridgeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("eventBridgeEnabled", eventBridgeEnabled)
    def getKmsKeyEnableGeospatialQueries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "kmsKeyEnableGeospatialQueries",
        kmsKeyEnableGeospatialQueries
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateTrackerRequest
  ) extends zio.aws.location.model.UpdateTrackerRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pricingPlanDataSource())
      .map(value => value: String)
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val positionFiltering
        : Optional[zio.aws.location.model.PositionFiltering] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positionFiltering())
        .map(value => zio.aws.location.model.PositionFiltering.wrap(value))
    override val eventBridgeEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBridgeEnabled())
      .map(value => value: Boolean)
    override val kmsKeyEnableGeospatialQueries: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyEnableGeospatialQueries())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateTrackerRequest
  ): zio.aws.location.model.UpdateTrackerRequest.ReadOnly = new Wrapper(impl)
}
