package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class VerifyDevicePositionRequest(
    trackerName: ResourceName,
    deviceState: zio.aws.location.model.DeviceState,
    distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.VerifyDevicePositionRequest = {
    import VerifyDevicePositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.VerifyDevicePositionRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .deviceState(deviceState.buildAwsValue())
      .optionallyWith(distanceUnit.map(value => value.unwrap))(_.distanceUnit)
      .build()
  }
  def asReadOnly: zio.aws.location.model.VerifyDevicePositionRequest.ReadOnly =
    zio.aws.location.model.VerifyDevicePositionRequest.wrap(buildAwsValue())
}
object VerifyDevicePositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.VerifyDevicePositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.VerifyDevicePositionRequest =
      zio.aws.location.model.VerifyDevicePositionRequest(
        trackerName,
        deviceState.asEditable,
        distanceUnit.map(value => value)
      )
    def trackerName: ResourceName
    def deviceState: zio.aws.location.model.DeviceState.ReadOnly
    def distanceUnit: Optional[zio.aws.location.model.DistanceUnit]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getDeviceState
        : ZIO[Any, Nothing, zio.aws.location.model.DeviceState.ReadOnly] =
      ZIO.succeed(deviceState)
    def getDistanceUnit
        : ZIO[Any, AwsError, zio.aws.location.model.DistanceUnit] =
      AwsError.unwrapOptionField("distanceUnit", distanceUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.VerifyDevicePositionRequest
  ) extends zio.aws.location.model.VerifyDevicePositionRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val deviceState: zio.aws.location.model.DeviceState.ReadOnly =
      zio.aws.location.model.DeviceState.wrap(impl.deviceState())
    override val distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distanceUnit())
        .map(value => zio.aws.location.model.DistanceUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.VerifyDevicePositionRequest
  ): zio.aws.location.model.VerifyDevicePositionRequest.ReadOnly = new Wrapper(
    impl
  )
}
