package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class VerifyDevicePositionResponse(
    inferredState: zio.aws.location.model.InferredState,
    deviceId: Id,
    sampleTime: Timestamp,
    receivedTime: Timestamp,
    distanceUnit: zio.aws.location.model.DistanceUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.VerifyDevicePositionResponse = {
    import VerifyDevicePositionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.VerifyDevicePositionResponse
      .builder()
      .inferredState(inferredState.buildAwsValue())
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .sampleTime(Timestamp.unwrap(sampleTime): Instant)
      .receivedTime(Timestamp.unwrap(receivedTime): Instant)
      .distanceUnit(distanceUnit.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.location.model.VerifyDevicePositionResponse.ReadOnly =
    zio.aws.location.model.VerifyDevicePositionResponse.wrap(buildAwsValue())
}
object VerifyDevicePositionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.VerifyDevicePositionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.VerifyDevicePositionResponse =
      zio.aws.location.model.VerifyDevicePositionResponse(
        inferredState.asEditable,
        deviceId,
        sampleTime,
        receivedTime,
        distanceUnit
      )
    def inferredState: zio.aws.location.model.InferredState.ReadOnly
    def deviceId: Id
    def sampleTime: Timestamp
    def receivedTime: Timestamp
    def distanceUnit: zio.aws.location.model.DistanceUnit
    def getInferredState
        : ZIO[Any, Nothing, zio.aws.location.model.InferredState.ReadOnly] =
      ZIO.succeed(inferredState)
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getSampleTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(sampleTime)
    def getReceivedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(receivedTime)
    def getDistanceUnit
        : ZIO[Any, Nothing, zio.aws.location.model.DistanceUnit] =
      ZIO.succeed(distanceUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.VerifyDevicePositionResponse
  ) extends zio.aws.location.model.VerifyDevicePositionResponse.ReadOnly {
    override val inferredState: zio.aws.location.model.InferredState.ReadOnly =
      zio.aws.location.model.InferredState.wrap(impl.inferredState())
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val sampleTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.sampleTime())
    override val receivedTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.receivedTime())
    override val distanceUnit: zio.aws.location.model.DistanceUnit =
      zio.aws.location.model.DistanceUnit.wrap(impl.distanceUnit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.VerifyDevicePositionResponse
  ): zio.aws.location.model.VerifyDevicePositionResponse.ReadOnly = new Wrapper(
    impl
  )
}
