package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  WiFiAccessPointRssInteger,
  WiFiAccessPointMacAddressString
}
import scala.jdk.CollectionConverters._
final case class WiFiAccessPoint(
    macAddress: WiFiAccessPointMacAddressString,
    rss: WiFiAccessPointRssInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.WiFiAccessPoint = {
    import WiFiAccessPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.WiFiAccessPoint
      .builder()
      .macAddress(
        WiFiAccessPointMacAddressString.unwrap(macAddress): java.lang.String
      )
      .rss(WiFiAccessPointRssInteger.unwrap(rss): Integer)
      .build()
  }
  def asReadOnly: zio.aws.location.model.WiFiAccessPoint.ReadOnly =
    zio.aws.location.model.WiFiAccessPoint.wrap(buildAwsValue())
}
object WiFiAccessPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.WiFiAccessPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.WiFiAccessPoint =
      zio.aws.location.model.WiFiAccessPoint(macAddress, rss)
    def macAddress: WiFiAccessPointMacAddressString
    def rss: WiFiAccessPointRssInteger
    def getMacAddress: ZIO[Any, Nothing, WiFiAccessPointMacAddressString] =
      ZIO.succeed(macAddress)
    def getRss: ZIO[Any, Nothing, WiFiAccessPointRssInteger] = ZIO.succeed(rss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.WiFiAccessPoint
  ) extends zio.aws.location.model.WiFiAccessPoint.ReadOnly {
    override val macAddress: WiFiAccessPointMacAddressString =
      zio.aws.location.model.primitives
        .WiFiAccessPointMacAddressString(impl.macAddress())
    override val rss: WiFiAccessPointRssInteger =
      zio.aws.location.model.primitives.WiFiAccessPointRssInteger(impl.rss())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.WiFiAccessPoint
  ): zio.aws.location.model.WiFiAccessPoint.ReadOnly = new Wrapper(impl)
}
