package zio.aws.location
import zio.aws.location.model.primitives.PlaceCategory.Type
import zio.aws.location.model.primitives.{
  PropertyMapKeyString,
  PlaceCategory,
  RefererPattern,
  PropertyMapValueString,
  TagValue,
  Arn,
  CustomLayer,
  ApiKeyAction,
  GeoArnV2,
  PlaceSupplementalCategory,
  Id,
  TagKey,
  CountryCode3
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ApiKey extends zio.prelude.Subtype[String]
    type ApiKey = zio.aws.location.model.primitives.ApiKey.Type
    object ApiKeyAction extends zio.prelude.Subtype[String]
    type ApiKeyAction = zio.aws.location.model.primitives.ApiKeyAction.Type
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.location.model.primitives.Arn.Type
    object Base64EncodedGeobuf extends zio.prelude.Subtype[Chunk[Byte]]
    type Base64EncodedGeobuf =
      zio.aws.location.model.primitives.Base64EncodedGeobuf.Type
    object BatchGetDevicePositionRequestTrackerNameString
        extends zio.prelude.Subtype[String]
    type BatchGetDevicePositionRequestTrackerNameString =
      zio.aws.location.model.primitives.BatchGetDevicePositionRequestTrackerNameString.Type
    object Blob extends zio.prelude.Subtype[Chunk[Byte]]
    type Blob = zio.aws.location.model.primitives.Blob.Type
    object CalculateRouteMatrixSummaryErrorCountInteger
        extends zio.prelude.Subtype[Int]
    type CalculateRouteMatrixSummaryErrorCountInteger =
      zio.aws.location.model.primitives.CalculateRouteMatrixSummaryErrorCountInteger.Type
    object CalculateRouteMatrixSummaryRouteCountInteger
        extends zio.prelude.Subtype[Int]
    type CalculateRouteMatrixSummaryRouteCountInteger =
      zio.aws.location.model.primitives.CalculateRouteMatrixSummaryRouteCountInteger.Type
    object CalculateRouteSummaryDistanceDouble
        extends zio.prelude.Subtype[Double]
    type CalculateRouteSummaryDistanceDouble =
      zio.aws.location.model.primitives.CalculateRouteSummaryDistanceDouble.Type
    object CalculateRouteSummaryDurationSecondsDouble
        extends zio.prelude.Subtype[Double]
    type CalculateRouteSummaryDurationSecondsDouble =
      zio.aws.location.model.primitives.CalculateRouteSummaryDurationSecondsDouble.Type
    object CountryCode3 extends zio.prelude.Subtype[String]
    type CountryCode3 = zio.aws.location.model.primitives.CountryCode3.Type
    object CountryCode3OrEmpty extends zio.prelude.Subtype[String]
    type CountryCode3OrEmpty =
      zio.aws.location.model.primitives.CountryCode3OrEmpty.Type
    object CustomLayer extends zio.prelude.Subtype[String]
    type CustomLayer = zio.aws.location.model.primitives.CustomLayer.Type
    object DescribeGeofenceCollectionResponseGeofenceCountInteger
        extends zio.prelude.Subtype[Int]
    type DescribeGeofenceCollectionResponseGeofenceCountInteger =
      zio.aws.location.model.primitives.DescribeGeofenceCollectionResponseGeofenceCountInteger.Type
    object DeviceStateIpv4AddressString extends zio.prelude.Subtype[String]
    type DeviceStateIpv4AddressString =
      zio.aws.location.model.primitives.DeviceStateIpv4AddressString.Type
    object Earfcn extends zio.prelude.Subtype[Int]
    type Earfcn = zio.aws.location.model.primitives.Earfcn.Type
    object EutranCellId extends zio.prelude.Subtype[Int]
    type EutranCellId = zio.aws.location.model.primitives.EutranCellId.Type
    object ForecastGeofenceEventsDeviceStateSpeedDouble
        extends zio.prelude.Subtype[Double]
    type ForecastGeofenceEventsDeviceStateSpeedDouble =
      zio.aws.location.model.primitives.ForecastGeofenceEventsDeviceStateSpeedDouble.Type
    object ForecastGeofenceEventsRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ForecastGeofenceEventsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ForecastGeofenceEventsRequestMaxResultsInteger.Type
    object ForecastGeofenceEventsRequestTimeHorizonMinutesDouble
        extends zio.prelude.Subtype[Double]
    type ForecastGeofenceEventsRequestTimeHorizonMinutesDouble =
      zio.aws.location.model.primitives.ForecastGeofenceEventsRequestTimeHorizonMinutesDouble.Type
    object GeoArn extends zio.prelude.Subtype[String]
    type GeoArn = zio.aws.location.model.primitives.GeoArn.Type
    object GeoArnV2 extends zio.prelude.Subtype[String]
    type GeoArnV2 = zio.aws.location.model.primitives.GeoArnV2.Type
    object GetDevicePositionHistoryRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type GetDevicePositionHistoryRequestMaxResultsInteger =
      zio.aws.location.model.primitives.GetDevicePositionHistoryRequestMaxResultsInteger.Type
    object GetMapGlyphsRequestFontUnicodeRangeString
        extends zio.prelude.Subtype[String]
    type GetMapGlyphsRequestFontUnicodeRangeString =
      zio.aws.location.model.primitives.GetMapGlyphsRequestFontUnicodeRangeString.Type
    object GetMapSpritesRequestFileNameString
        extends zio.prelude.Subtype[String]
    type GetMapSpritesRequestFileNameString =
      zio.aws.location.model.primitives.GetMapSpritesRequestFileNameString.Type
    object GetMapTileRequestXString extends zio.prelude.Subtype[String]
    type GetMapTileRequestXString =
      zio.aws.location.model.primitives.GetMapTileRequestXString.Type
    object GetMapTileRequestYString extends zio.prelude.Subtype[String]
    type GetMapTileRequestYString =
      zio.aws.location.model.primitives.GetMapTileRequestYString.Type
    object GetMapTileRequestZString extends zio.prelude.Subtype[String]
    type GetMapTileRequestZString =
      zio.aws.location.model.primitives.GetMapTileRequestZString.Type
    object Id extends zio.prelude.Subtype[String]
    type Id = zio.aws.location.model.primitives.Id.Type
    type Integer = Int
    object KmsKeyId extends zio.prelude.Subtype[String]
    type KmsKeyId = zio.aws.location.model.primitives.KmsKeyId.Type
    object LanguageTag extends zio.prelude.Subtype[String]
    type LanguageTag = zio.aws.location.model.primitives.LanguageTag.Type
    object LargeToken extends zio.prelude.Subtype[String]
    type LargeToken = zio.aws.location.model.primitives.LargeToken.Type
    object LegDistanceDouble extends zio.prelude.Subtype[Double]
    type LegDistanceDouble =
      zio.aws.location.model.primitives.LegDistanceDouble.Type
    object LegDurationSecondsDouble extends zio.prelude.Subtype[Double]
    type LegDurationSecondsDouble =
      zio.aws.location.model.primitives.LegDurationSecondsDouble.Type
    object ListDevicePositionsRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ListDevicePositionsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListDevicePositionsRequestMaxResultsInteger.Type
    object ListGeofenceCollectionsRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ListGeofenceCollectionsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListGeofenceCollectionsRequestMaxResultsInteger.Type
    object ListGeofencesRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ListGeofencesRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListGeofencesRequestMaxResultsInteger.Type
    object ListKeysRequestMaxResultsInteger extends zio.prelude.Subtype[Int]
    type ListKeysRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListKeysRequestMaxResultsInteger.Type
    object ListMapsRequestMaxResultsInteger extends zio.prelude.Subtype[Int]
    type ListMapsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListMapsRequestMaxResultsInteger.Type
    object ListPlaceIndexesRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ListPlaceIndexesRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListPlaceIndexesRequestMaxResultsInteger.Type
    object ListRouteCalculatorsRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ListRouteCalculatorsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListRouteCalculatorsRequestMaxResultsInteger.Type
    object ListTrackerConsumersRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type ListTrackerConsumersRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListTrackerConsumersRequestMaxResultsInteger.Type
    object ListTrackersRequestMaxResultsInteger extends zio.prelude.Subtype[Int]
    type ListTrackersRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListTrackersRequestMaxResultsInteger.Type
    object LteCellDetailsMccInteger extends zio.prelude.Subtype[Int]
    type LteCellDetailsMccInteger =
      zio.aws.location.model.primitives.LteCellDetailsMccInteger.Type
    object LteCellDetailsMncInteger extends zio.prelude.Subtype[Int]
    type LteCellDetailsMncInteger =
      zio.aws.location.model.primitives.LteCellDetailsMncInteger.Type
    object LteCellDetailsTacInteger extends zio.prelude.Subtype[Int]
    type LteCellDetailsTacInteger =
      zio.aws.location.model.primitives.LteCellDetailsTacInteger.Type
    object LteCellDetailsTimingAdvanceInteger extends zio.prelude.Subtype[Int]
    type LteCellDetailsTimingAdvanceInteger =
      zio.aws.location.model.primitives.LteCellDetailsTimingAdvanceInteger.Type
    object MapStyle extends zio.prelude.Subtype[String]
    type MapStyle = zio.aws.location.model.primitives.MapStyle.Type
    object NearestDistance extends zio.prelude.Subtype[Double]
    type NearestDistance =
      zio.aws.location.model.primitives.NearestDistance.Type
    object Pci extends zio.prelude.Subtype[Int]
    type Pci = zio.aws.location.model.primitives.Pci.Type
    object PlaceCategory extends zio.prelude.Subtype[String]
    type PlaceCategory = zio.aws.location.model.primitives.PlaceCategory.Type
    object PlaceId extends zio.prelude.Subtype[String]
    type PlaceId = zio.aws.location.model.primitives.PlaceId.Type
    object PlaceIndexSearchResultLimit extends zio.prelude.Subtype[Int]
    type PlaceIndexSearchResultLimit =
      zio.aws.location.model.primitives.PlaceIndexSearchResultLimit.Type
    object PlaceSupplementalCategory extends zio.prelude.Subtype[String]
    type PlaceSupplementalCategory =
      zio.aws.location.model.primitives.PlaceSupplementalCategory.Type
    object PositionalAccuracyHorizontalDouble
        extends zio.prelude.Subtype[Double]
    type PositionalAccuracyHorizontalDouble =
      zio.aws.location.model.primitives.PositionalAccuracyHorizontalDouble.Type
    object PropertyMapKeyString extends zio.prelude.Subtype[String]
    type PropertyMapKeyString =
      zio.aws.location.model.primitives.PropertyMapKeyString.Type
    object PropertyMapValueString extends zio.prelude.Subtype[String]
    type PropertyMapValueString =
      zio.aws.location.model.primitives.PropertyMapValueString.Type
    object RefererPattern extends zio.prelude.Subtype[String]
    type RefererPattern = zio.aws.location.model.primitives.RefererPattern.Type
    object ResourceDescription extends zio.prelude.Subtype[String]
    type ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription.Type
    object ResourceName extends zio.prelude.Subtype[String]
    type ResourceName = zio.aws.location.model.primitives.ResourceName.Type
    object RouteMatrixEntryDistanceDouble extends zio.prelude.Subtype[Double]
    type RouteMatrixEntryDistanceDouble =
      zio.aws.location.model.primitives.RouteMatrixEntryDistanceDouble.Type
    object RouteMatrixEntryDurationSecondsDouble
        extends zio.prelude.Subtype[Double]
    type RouteMatrixEntryDurationSecondsDouble =
      zio.aws.location.model.primitives.RouteMatrixEntryDurationSecondsDouble.Type
    object Rsrp extends zio.prelude.Subtype[Int]
    type Rsrp = zio.aws.location.model.primitives.Rsrp.Type
    object Rsrq extends zio.prelude.Subtype[Float]
    type Rsrq = zio.aws.location.model.primitives.Rsrq.Type
    object SearchForPositionResultDistanceDouble
        extends zio.prelude.Subtype[Double]
    type SearchForPositionResultDistanceDouble =
      zio.aws.location.model.primitives.SearchForPositionResultDistanceDouble.Type
    object SearchForTextResultDistanceDouble extends zio.prelude.Subtype[Double]
    type SearchForTextResultDistanceDouble =
      zio.aws.location.model.primitives.SearchForTextResultDistanceDouble.Type
    object SearchForTextResultRelevanceDouble
        extends zio.prelude.Subtype[Double]
    type SearchForTextResultRelevanceDouble =
      zio.aws.location.model.primitives.SearchForTextResultRelevanceDouble.Type
    object SearchPlaceIndexForSuggestionsRequestMaxResultsInteger
        extends zio.prelude.Subtype[Int]
    type SearchPlaceIndexForSuggestionsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.SearchPlaceIndexForSuggestionsRequestMaxResultsInteger.Type
    object SearchPlaceIndexForSuggestionsRequestTextString
        extends zio.prelude.Subtype[String]
    type SearchPlaceIndexForSuggestionsRequestTextString =
      zio.aws.location.model.primitives.SearchPlaceIndexForSuggestionsRequestTextString.Type
    object SearchPlaceIndexForTextRequestTextString
        extends zio.prelude.Subtype[String]
    type SearchPlaceIndexForTextRequestTextString =
      zio.aws.location.model.primitives.SearchPlaceIndexForTextRequestTextString.Type
    object SensitiveString extends zio.prelude.Subtype[String]
    type SensitiveString =
      zio.aws.location.model.primitives.SensitiveString.Type
    object StepDistanceDouble extends zio.prelude.Subtype[Double]
    type StepDistanceDouble =
      zio.aws.location.model.primitives.StepDistanceDouble.Type
    object StepDurationSecondsDouble extends zio.prelude.Subtype[Double]
    type StepDurationSecondsDouble =
      zio.aws.location.model.primitives.StepDurationSecondsDouble.Type
    object StepGeometryOffsetInteger extends zio.prelude.Subtype[Int]
    type StepGeometryOffsetInteger =
      zio.aws.location.model.primitives.StepGeometryOffsetInteger.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.location.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.location.model.primitives.TagValue.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.location.model.primitives.Timestamp.Type
    object Token extends zio.prelude.Subtype[String]
    type Token = zio.aws.location.model.primitives.Token.Type
    object TruckDimensionsHeightDouble extends zio.prelude.Subtype[Double]
    type TruckDimensionsHeightDouble =
      zio.aws.location.model.primitives.TruckDimensionsHeightDouble.Type
    object TruckDimensionsLengthDouble extends zio.prelude.Subtype[Double]
    type TruckDimensionsLengthDouble =
      zio.aws.location.model.primitives.TruckDimensionsLengthDouble.Type
    object TruckDimensionsWidthDouble extends zio.prelude.Subtype[Double]
    type TruckDimensionsWidthDouble =
      zio.aws.location.model.primitives.TruckDimensionsWidthDouble.Type
    object TruckWeightTotalDouble extends zio.prelude.Subtype[Double]
    type TruckWeightTotalDouble =
      zio.aws.location.model.primitives.TruckWeightTotalDouble.Type
    object Uuid extends zio.prelude.Subtype[String]
    type Uuid = zio.aws.location.model.primitives.Uuid.Type
    object WiFiAccessPointMacAddressString extends zio.prelude.Subtype[String]
    type WiFiAccessPointMacAddressString =
      zio.aws.location.model.primitives.WiFiAccessPointMacAddressString.Type
    object WiFiAccessPointRssInteger extends zio.prelude.Subtype[Int]
    type WiFiAccessPointRssInteger =
      zio.aws.location.model.primitives.WiFiAccessPointRssInteger.Type
  }
  type ApiKeyRestrictionsAllowActionsList = List[ApiKeyAction]
  type ApiKeyRestrictionsAllowReferersList = List[RefererPattern]
  type ApiKeyRestrictionsAllowResourcesList = List[GeoArnV2]
  type ArnList = List[Arn]
  type BatchDeleteDevicePositionHistoryErrorList =
    List[zio.aws.location.model.BatchDeleteDevicePositionHistoryError]
  type BatchDeleteDevicePositionHistoryRequestDeviceIdsList = List[Id]
  type BatchDeleteGeofenceErrorList =
    List[zio.aws.location.model.BatchDeleteGeofenceError]
  type BatchDeleteGeofenceRequestGeofenceIdsList = List[Id]
  type BatchEvaluateGeofencesErrorList =
    List[zio.aws.location.model.BatchEvaluateGeofencesError]
  type BatchEvaluateGeofencesRequestDevicePositionUpdatesList =
    List[zio.aws.location.model.DevicePositionUpdate]
  type BatchGetDevicePositionErrorList =
    List[zio.aws.location.model.BatchGetDevicePositionError]
  type BatchGetDevicePositionRequestDeviceIdsList = List[Id]
  type BatchPutGeofenceErrorList =
    List[zio.aws.location.model.BatchPutGeofenceError]
  type BatchPutGeofenceRequestEntriesList =
    List[zio.aws.location.model.BatchPutGeofenceRequestEntry]
  type BatchPutGeofenceSuccessList =
    List[zio.aws.location.model.BatchPutGeofenceSuccess]
  type BatchUpdateDevicePositionErrorList =
    List[zio.aws.location.model.BatchUpdateDevicePositionError]
  type BatchUpdateDevicePositionRequestUpdatesList =
    List[zio.aws.location.model.DevicePositionUpdate]
  type BoundingBox = List[Double]
  type CalculateRouteMatrixRequestDeparturePositionsList =
    List[Iterable[Double]]
  type CalculateRouteMatrixRequestDestinationPositionsList =
    List[Iterable[Double]]
  type CalculateRouteMatrixResponseSnappedDeparturePositionsList =
    List[Iterable[Double]]
  type CalculateRouteMatrixResponseSnappedDestinationPositionsList =
    List[Iterable[Double]]
  type CalculateRouteRequestWaypointPositionsList = List[Iterable[Double]]
  type CellSignalsLteCellDetailsList =
    List[zio.aws.location.model.LteCellDetails]
  type CountryCodeList = List[CountryCode3]
  type CustomLayerList = List[CustomLayer]
  type DevicePositionList = List[zio.aws.location.model.DevicePosition]
  type FilterPlaceCategoryList = List[PlaceCategory]
  type ForecastedEventsList = List[zio.aws.location.model.ForecastedEvent]
  type LegList = List[zio.aws.location.model.Leg]
  type LineString = List[Iterable[Double]]
  type LinearRing = List[Iterable[Double]]
  type LinearRings = List[Iterable[Iterable[Double]]]
  type ListDevicePositionsResponseEntryList =
    List[zio.aws.location.model.ListDevicePositionsResponseEntry]
  type ListGeofenceCollectionsResponseEntryList =
    List[zio.aws.location.model.ListGeofenceCollectionsResponseEntry]
  type ListGeofenceResponseEntryList =
    List[zio.aws.location.model.ListGeofenceResponseEntry]
  type ListKeysResponseEntryList =
    List[zio.aws.location.model.ListKeysResponseEntry]
  type ListMapsResponseEntryList =
    List[zio.aws.location.model.ListMapsResponseEntry]
  type ListPlaceIndexesResponseEntryList =
    List[zio.aws.location.model.ListPlaceIndexesResponseEntry]
  type ListRouteCalculatorsResponseEntryList =
    List[zio.aws.location.model.ListRouteCalculatorsResponseEntry]
  type ListTrackersResponseEntryList =
    List[zio.aws.location.model.ListTrackersResponseEntry]
  type LteCellDetailsNetworkMeasurementsList =
    List[zio.aws.location.model.LteNetworkMeasurements]
  type PlaceCategoryList = List[PlaceCategory]
  type PlaceSupplementalCategoryList = List[PlaceSupplementalCategory]
  type Position = List[Double]
  type PropertyMap = Map[PropertyMapKeyString, PropertyMapValueString]
  type RouteMatrix = List[Iterable[zio.aws.location.model.RouteMatrixEntry]]
  type RouteMatrixRow = List[zio.aws.location.model.RouteMatrixEntry]
  type SearchForPositionResultList =
    List[zio.aws.location.model.SearchForPositionResult]
  type SearchForSuggestionsResultList =
    List[zio.aws.location.model.SearchForSuggestionsResult]
  type SearchForTextResultList =
    List[zio.aws.location.model.SearchForTextResult]
  type StepList = List[zio.aws.location.model.Step]
  type TagKeys = List[String]
  type TagMap = Map[TagKey, TagValue]
  type WiFiAccessPointList = List[zio.aws.location.model.WiFiAccessPoint]
}
