package zio.aws.macie2
import software.amazon.awssdk.services.macie2.Macie2AsyncClient
import zio.aws.macie2.model.UpdateClassificationJobResponse.ReadOnly
import zio.aws.macie2.model.{
  GetBucketStatisticsRequest,
  ListClassificationScopesRequest,
  EnableOrganizationAdminAccountRequest,
  UpdateClassificationScopeRequest,
  UpdateFindingsFilterRequest,
  GetFindingsPublicationConfigurationRequest,
  TestCustomDataIdentifierRequest,
  SearchResourcesRequest,
  DisableOrganizationAdminAccountRequest,
  CreateClassificationJobRequest,
  CreateMemberRequest,
  CreateInvitationsRequest,
  DeleteInvitationsRequest,
  ListResourceProfileDetectionsRequest,
  CreateSampleFindingsRequest,
  DisableMacieRequest,
  CreateFindingsFilterRequest,
  DisassociateFromMasterAccountRequest,
  GetMacieSessionRequest,
  EnableMacieRequest,
  GetAutomatedDiscoveryConfigurationRequest,
  ListMembersRequest,
  UpdateRevealConfigurationRequest,
  UpdateAutomatedDiscoveryConfigurationRequest,
  GetRevealConfigurationRequest,
  ListClassificationJobsRequest,
  PutClassificationExportConfigurationRequest,
  GetClassificationExportConfigurationRequest,
  ListTagsForResourceRequest,
  CreateCustomDataIdentifierRequest,
  CreateAllowListRequest,
  GetFindingsRequest,
  DeleteAllowListRequest,
  PutFindingsPublicationConfigurationRequest,
  DeleteCustomDataIdentifierRequest,
  GetResourceProfileRequest,
  UpdateSensitivityInspectionTemplateRequest,
  GetAllowListRequest,
  GetSensitiveDataOccurrencesAvailabilityRequest,
  DescribeClassificationJobRequest,
  GetAdministratorAccountRequest,
  DeclineInvitationsRequest,
  ListOrganizationAdminAccountsRequest,
  GetMemberRequest,
  ListFindingsRequest,
  UpdateOrganizationConfigurationRequest,
  ListInvitationsRequest,
  GetFindingStatisticsRequest,
  BatchUpdateAutomatedDiscoveryAccountsRequest,
  ListResourceProfileArtifactsRequest,
  DeleteFindingsFilterRequest,
  ListAllowListsRequest,
  BatchGetCustomDataIdentifiersRequest,
  UpdateResourceProfileRequest,
  DeleteMemberRequest,
  UntagResourceRequest,
  UpdateAllowListRequest,
  ListManagedDataIdentifiersRequest,
  UpdateMemberSessionRequest,
  ListAutomatedDiscoveryAccountsRequest,
  GetFindingsFilterRequest,
  AcceptInvitationRequest,
  GetUsageStatisticsRequest,
  UpdateMacieSessionRequest,
  ListCustomDataIdentifiersRequest,
  DescribeBucketsRequest,
  DisassociateMemberRequest,
  UpdateResourceProfileDetectionsRequest,
  GetClassificationScopeRequest,
  GetSensitivityInspectionTemplateRequest,
  UpdateClassificationJobRequest,
  DescribeOrganizationConfigurationRequest,
  GetInvitationsCountRequest,
  ListFindingsFiltersRequest,
  GetCustomDataIdentifierRequest,
  GetMasterAccountRequest,
  DisassociateFromAdministratorAccountRequest,
  TagResourceRequest,
  GetSensitiveDataOccurrencesRequest,
  ListSensitivityInspectionTemplatesRequest,
  GetUsageTotalsRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.macie2.model.primitives.__string
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object Macie2Mock extends Mock[Macie2] {
  object GetAdministratorAccount
      extends Effect[
        GetAdministratorAccountRequest,
        AwsError,
        zio.aws.macie2.model.GetAdministratorAccountResponse.ReadOnly
      ]
  object ListFindings extends Stream[ListFindingsRequest, AwsError, __string]
  object ListFindingsPaginated
      extends Effect[
        ListFindingsRequest,
        AwsError,
        zio.aws.macie2.model.ListFindingsResponse.ReadOnly
      ]
  object ListClassificationJobs
      extends Stream[
        ListClassificationJobsRequest,
        AwsError,
        zio.aws.macie2.model.JobSummary.ReadOnly
      ]
  object ListClassificationJobsPaginated
      extends Effect[
        ListClassificationJobsRequest,
        AwsError,
        zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly
      ]
  object UpdateAutomatedDiscoveryConfiguration
      extends Effect[
        UpdateAutomatedDiscoveryConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.UpdateAutomatedDiscoveryConfigurationResponse.ReadOnly
      ]
  object DisableOrganizationAdminAccount
      extends Effect[
        DisableOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.macie2.model.DisableOrganizationAdminAccountResponse.ReadOnly
      ]
  object ListAutomatedDiscoveryAccounts
      extends Stream[
        ListAutomatedDiscoveryAccountsRequest,
        AwsError,
        zio.aws.macie2.model.AutomatedDiscoveryAccount.ReadOnly
      ]
  object ListAutomatedDiscoveryAccountsPaginated
      extends Effect[
        ListAutomatedDiscoveryAccountsRequest,
        AwsError,
        zio.aws.macie2.model.ListAutomatedDiscoveryAccountsResponse.ReadOnly
      ]
  object ListResourceProfileArtifacts
      extends Stream[
        ListResourceProfileArtifactsRequest,
        AwsError,
        zio.aws.macie2.model.ResourceProfileArtifact.ReadOnly
      ]
  object ListResourceProfileArtifactsPaginated
      extends Effect[
        ListResourceProfileArtifactsRequest,
        AwsError,
        zio.aws.macie2.model.ListResourceProfileArtifactsResponse.ReadOnly
      ]
  object CreateSampleFindings
      extends Effect[
        CreateSampleFindingsRequest,
        AwsError,
        zio.aws.macie2.model.CreateSampleFindingsResponse.ReadOnly
      ]
  object GetMacieSession
      extends Effect[
        GetMacieSessionRequest,
        AwsError,
        zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly
      ]
  object CreateClassificationJob
      extends Effect[
        CreateClassificationJobRequest,
        AwsError,
        zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly
      ]
  object ListOrganizationAdminAccounts
      extends Stream[
        ListOrganizationAdminAccountsRequest,
        AwsError,
        zio.aws.macie2.model.AdminAccount.ReadOnly
      ]
  object ListOrganizationAdminAccountsPaginated
      extends Effect[
        ListOrganizationAdminAccountsRequest,
        AwsError,
        zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly
      ]
  object UpdateOrganizationConfiguration
      extends Effect[
        UpdateOrganizationConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.UpdateOrganizationConfigurationResponse.ReadOnly
      ]
  object UpdateResourceProfileDetections
      extends Effect[
        UpdateResourceProfileDetectionsRequest,
        AwsError,
        zio.aws.macie2.model.UpdateResourceProfileDetectionsResponse.ReadOnly
      ]
  object UpdateFindingsFilter
      extends Effect[
        UpdateFindingsFilterRequest,
        AwsError,
        zio.aws.macie2.model.UpdateFindingsFilterResponse.ReadOnly
      ]
  object CreateMember
      extends Effect[
        CreateMemberRequest,
        AwsError,
        zio.aws.macie2.model.CreateMemberResponse.ReadOnly
      ]
  object BatchUpdateAutomatedDiscoveryAccounts
      extends Effect[
        BatchUpdateAutomatedDiscoveryAccountsRequest,
        AwsError,
        zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse.ReadOnly
      ]
  object PutFindingsPublicationConfiguration
      extends Effect[
        PutFindingsPublicationConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.PutFindingsPublicationConfigurationResponse.ReadOnly
      ]
  object GetAutomatedDiscoveryConfiguration
      extends Effect[
        GetAutomatedDiscoveryConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.GetAutomatedDiscoveryConfigurationResponse.ReadOnly
      ]
  object CreateInvitations
      extends Effect[
        CreateInvitationsRequest,
        AwsError,
        zio.aws.macie2.model.CreateInvitationsResponse.ReadOnly
      ]
  object DisassociateMember
      extends Effect[
        DisassociateMemberRequest,
        AwsError,
        zio.aws.macie2.model.DisassociateMemberResponse.ReadOnly
      ]
  object ListFindingsFilters
      extends Stream[
        ListFindingsFiltersRequest,
        AwsError,
        zio.aws.macie2.model.FindingsFilterListItem.ReadOnly
      ]
  object ListFindingsFiltersPaginated
      extends Effect[
        ListFindingsFiltersRequest,
        AwsError,
        zio.aws.macie2.model.ListFindingsFiltersResponse.ReadOnly
      ]
  object GetInvitationsCount
      extends Effect[
        GetInvitationsCountRequest,
        AwsError,
        zio.aws.macie2.model.GetInvitationsCountResponse.ReadOnly
      ]
  object CreateCustomDataIdentifier
      extends Effect[
        CreateCustomDataIdentifierRequest,
        AwsError,
        zio.aws.macie2.model.CreateCustomDataIdentifierResponse.ReadOnly
      ]
  object UpdateMacieSession
      extends Effect[
        UpdateMacieSessionRequest,
        AwsError,
        zio.aws.macie2.model.UpdateMacieSessionResponse.ReadOnly
      ]
  object GetSensitivityInspectionTemplate
      extends Effect[
        GetSensitivityInspectionTemplateRequest,
        AwsError,
        zio.aws.macie2.model.GetSensitivityInspectionTemplateResponse.ReadOnly
      ]
  object DisassociateFromMasterAccount
      extends Effect[
        DisassociateFromMasterAccountRequest,
        AwsError,
        zio.aws.macie2.model.DisassociateFromMasterAccountResponse.ReadOnly
      ]
  object GetResourceProfile
      extends Effect[
        GetResourceProfileRequest,
        AwsError,
        zio.aws.macie2.model.GetResourceProfileResponse.ReadOnly
      ]
  object UpdateAllowList
      extends Effect[
        UpdateAllowListRequest,
        AwsError,
        zio.aws.macie2.model.UpdateAllowListResponse.ReadOnly
      ]
  object PutClassificationExportConfiguration
      extends Effect[
        PutClassificationExportConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.PutClassificationExportConfigurationResponse.ReadOnly
      ]
  object ListMembers
      extends Stream[
        ListMembersRequest,
        AwsError,
        zio.aws.macie2.model.Member.ReadOnly
      ]
  object ListMembersPaginated
      extends Effect[
        ListMembersRequest,
        AwsError,
        zio.aws.macie2.model.ListMembersResponse.ReadOnly
      ]
  object UpdateResourceProfile
      extends Effect[
        UpdateResourceProfileRequest,
        AwsError,
        zio.aws.macie2.model.UpdateResourceProfileResponse.ReadOnly
      ]
  object ListManagedDataIdentifiers
      extends Stream[
        ListManagedDataIdentifiersRequest,
        AwsError,
        zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly
      ]
  object ListManagedDataIdentifiersPaginated
      extends Effect[
        ListManagedDataIdentifiersRequest,
        AwsError,
        zio.aws.macie2.model.ListManagedDataIdentifiersResponse.ReadOnly
      ]
  object DescribeBuckets
      extends Stream[
        DescribeBucketsRequest,
        AwsError,
        zio.aws.macie2.model.BucketMetadata.ReadOnly
      ]
  object DescribeBucketsPaginated
      extends Effect[
        DescribeBucketsRequest,
        AwsError,
        zio.aws.macie2.model.DescribeBucketsResponse.ReadOnly
      ]
  object GetAllowList
      extends Effect[
        GetAllowListRequest,
        AwsError,
        zio.aws.macie2.model.GetAllowListResponse.ReadOnly
      ]
  object EnableMacie
      extends Effect[
        EnableMacieRequest,
        AwsError,
        zio.aws.macie2.model.EnableMacieResponse.ReadOnly
      ]
  object GetSensitiveDataOccurrencesAvailability
      extends Effect[
        GetSensitiveDataOccurrencesAvailabilityRequest,
        AwsError,
        zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.ReadOnly
      ]
  object ListResourceProfileDetections
      extends Stream[
        ListResourceProfileDetectionsRequest,
        AwsError,
        zio.aws.macie2.model.Detection.ReadOnly
      ]
  object ListResourceProfileDetectionsPaginated
      extends Effect[
        ListResourceProfileDetectionsRequest,
        AwsError,
        zio.aws.macie2.model.ListResourceProfileDetectionsResponse.ReadOnly
      ]
  object GetFindingStatistics
      extends Effect[
        GetFindingStatisticsRequest,
        AwsError,
        zio.aws.macie2.model.GetFindingStatisticsResponse.ReadOnly
      ]
  object ListClassificationScopes
      extends Stream[
        ListClassificationScopesRequest,
        AwsError,
        zio.aws.macie2.model.ClassificationScopeSummary.ReadOnly
      ]
  object ListClassificationScopesPaginated
      extends Effect[
        ListClassificationScopesRequest,
        AwsError,
        zio.aws.macie2.model.ListClassificationScopesResponse.ReadOnly
      ]
  object GetRevealConfiguration
      extends Effect[
        GetRevealConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.GetRevealConfigurationResponse.ReadOnly
      ]
  object DeleteAllowList
      extends Effect[
        DeleteAllowListRequest,
        AwsError,
        zio.aws.macie2.model.DeleteAllowListResponse.ReadOnly
      ]
  object SearchResources
      extends Stream[
        SearchResourcesRequest,
        AwsError,
        zio.aws.macie2.model.MatchingResource.ReadOnly
      ]
  object SearchResourcesPaginated
      extends Effect[
        SearchResourcesRequest,
        AwsError,
        zio.aws.macie2.model.SearchResourcesResponse.ReadOnly
      ]
  object CreateAllowList
      extends Effect[
        CreateAllowListRequest,
        AwsError,
        zio.aws.macie2.model.CreateAllowListResponse.ReadOnly
      ]
  object DisableMacie
      extends Effect[
        DisableMacieRequest,
        AwsError,
        zio.aws.macie2.model.DisableMacieResponse.ReadOnly
      ]
  object GetSensitiveDataOccurrences
      extends Effect[
        GetSensitiveDataOccurrencesRequest,
        AwsError,
        zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.macie2.model.UntagResourceResponse.ReadOnly
      ]
  object GetClassificationScope
      extends Effect[
        GetClassificationScopeRequest,
        AwsError,
        zio.aws.macie2.model.GetClassificationScopeResponse.ReadOnly
      ]
  object GetFindings
      extends Effect[
        GetFindingsRequest,
        AwsError,
        zio.aws.macie2.model.GetFindingsResponse.ReadOnly
      ]
  object GetMember
      extends Effect[
        GetMemberRequest,
        AwsError,
        zio.aws.macie2.model.GetMemberResponse.ReadOnly
      ]
  object GetCustomDataIdentifier
      extends Effect[
        GetCustomDataIdentifierRequest,
        AwsError,
        zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly
      ]
  object DescribeOrganizationConfiguration
      extends Effect[
        DescribeOrganizationConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.ReadOnly
      ]
  object ListSensitivityInspectionTemplates
      extends Stream[
        ListSensitivityInspectionTemplatesRequest,
        AwsError,
        zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.ReadOnly
      ]
  object ListSensitivityInspectionTemplatesPaginated
      extends Effect[
        ListSensitivityInspectionTemplatesRequest,
        AwsError,
        zio.aws.macie2.model.ListSensitivityInspectionTemplatesResponse.ReadOnly
      ]
  object AcceptInvitation
      extends Effect[
        AcceptInvitationRequest,
        AwsError,
        zio.aws.macie2.model.AcceptInvitationResponse.ReadOnly
      ]
  object DeleteMember
      extends Effect[
        DeleteMemberRequest,
        AwsError,
        zio.aws.macie2.model.DeleteMemberResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.macie2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetFindingsPublicationConfiguration
      extends Effect[
        GetFindingsPublicationConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.ReadOnly
      ]
  object GetClassificationExportConfiguration
      extends Effect[
        GetClassificationExportConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.GetClassificationExportConfigurationResponse.ReadOnly
      ]
  object DescribeClassificationJob
      extends Effect[
        DescribeClassificationJobRequest,
        AwsError,
        zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.macie2.model.TagResourceResponse.ReadOnly
      ]
  object ListInvitations
      extends Stream[
        ListInvitationsRequest,
        AwsError,
        zio.aws.macie2.model.Invitation.ReadOnly
      ]
  object ListInvitationsPaginated
      extends Effect[
        ListInvitationsRequest,
        AwsError,
        zio.aws.macie2.model.ListInvitationsResponse.ReadOnly
      ]
  object BatchGetCustomDataIdentifiers
      extends Effect[
        BatchGetCustomDataIdentifiersRequest,
        AwsError,
        zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.ReadOnly
      ]
  object DeleteFindingsFilter
      extends Effect[
        DeleteFindingsFilterRequest,
        AwsError,
        zio.aws.macie2.model.DeleteFindingsFilterResponse.ReadOnly
      ]
  object GetFindingsFilter
      extends Effect[
        GetFindingsFilterRequest,
        AwsError,
        zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly
      ]
  object DeclineInvitations
      extends Effect[
        DeclineInvitationsRequest,
        AwsError,
        zio.aws.macie2.model.DeclineInvitationsResponse.ReadOnly
      ]
  object GetUsageTotals
      extends Effect[
        GetUsageTotalsRequest,
        AwsError,
        zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly
      ]
  object GetBucketStatistics
      extends Effect[
        GetBucketStatisticsRequest,
        AwsError,
        zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly
      ]
  object ListAllowLists
      extends Stream[
        ListAllowListsRequest,
        AwsError,
        zio.aws.macie2.model.AllowListSummary.ReadOnly
      ]
  object ListAllowListsPaginated
      extends Effect[
        ListAllowListsRequest,
        AwsError,
        zio.aws.macie2.model.ListAllowListsResponse.ReadOnly
      ]
  object UpdateSensitivityInspectionTemplate
      extends Effect[
        UpdateSensitivityInspectionTemplateRequest,
        AwsError,
        zio.aws.macie2.model.UpdateSensitivityInspectionTemplateResponse.ReadOnly
      ]
  object UpdateClassificationScope
      extends Effect[
        UpdateClassificationScopeRequest,
        AwsError,
        zio.aws.macie2.model.UpdateClassificationScopeResponse.ReadOnly
      ]
  object CreateFindingsFilter
      extends Effect[
        CreateFindingsFilterRequest,
        AwsError,
        zio.aws.macie2.model.CreateFindingsFilterResponse.ReadOnly
      ]
  object EnableOrganizationAdminAccount
      extends Effect[
        EnableOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.macie2.model.EnableOrganizationAdminAccountResponse.ReadOnly
      ]
  object GetMasterAccount
      extends Effect[
        GetMasterAccountRequest,
        AwsError,
        zio.aws.macie2.model.GetMasterAccountResponse.ReadOnly
      ]
  object ListCustomDataIdentifiers
      extends Stream[
        ListCustomDataIdentifiersRequest,
        AwsError,
        zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly
      ]
  object ListCustomDataIdentifiersPaginated
      extends Effect[
        ListCustomDataIdentifiersRequest,
        AwsError,
        zio.aws.macie2.model.ListCustomDataIdentifiersResponse.ReadOnly
      ]
  object DeleteInvitations
      extends Effect[
        DeleteInvitationsRequest,
        AwsError,
        zio.aws.macie2.model.DeleteInvitationsResponse.ReadOnly
      ]
  object UpdateClassificationJob
      extends Effect[UpdateClassificationJobRequest, AwsError, ReadOnly]
  object TestCustomDataIdentifier
      extends Effect[
        TestCustomDataIdentifierRequest,
        AwsError,
        zio.aws.macie2.model.TestCustomDataIdentifierResponse.ReadOnly
      ]
  object UpdateRevealConfiguration
      extends Effect[
        UpdateRevealConfigurationRequest,
        AwsError,
        zio.aws.macie2.model.UpdateRevealConfigurationResponse.ReadOnly
      ]
  object DeleteCustomDataIdentifier
      extends Effect[
        DeleteCustomDataIdentifierRequest,
        AwsError,
        zio.aws.macie2.model.DeleteCustomDataIdentifierResponse.ReadOnly
      ]
  object DisassociateFromAdministratorAccount
      extends Effect[
        DisassociateFromAdministratorAccountRequest,
        AwsError,
        zio.aws.macie2.model.DisassociateFromAdministratorAccountResponse.ReadOnly
      ]
  object GetUsageStatistics
      extends Stream[
        GetUsageStatisticsRequest,
        AwsError,
        zio.aws.macie2.model.UsageRecord.ReadOnly
      ]
  object GetUsageStatisticsPaginated
      extends Effect[
        GetUsageStatisticsRequest,
        AwsError,
        zio.aws.macie2.model.GetUsageStatisticsResponse.ReadOnly
      ]
  object UpdateMemberSession
      extends Effect[
        UpdateMemberSessionRequest,
        AwsError,
        zio.aws.macie2.model.UpdateMemberSessionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Macie2] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Macie2] { rts =>
        zio.ZIO.succeed {
          new Macie2 {
            val api: Macie2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Macie2 = this
            def getAdministratorAccount(
                request: GetAdministratorAccountRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetAdministratorAccountResponse.ReadOnly
            ] = proxy(GetAdministratorAccount, request)
            def listFindings(
                request: ListFindingsRequest
            ): ZStream[Any, AwsError, __string] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFindings, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFindingsPaginated(request: ListFindingsRequest): IO[
              AwsError,
              zio.aws.macie2.model.ListFindingsResponse.ReadOnly
            ] = proxy(ListFindingsPaginated, request)
            def listClassificationJobs(
                request: ListClassificationJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.JobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListClassificationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listClassificationJobsPaginated(
                request: ListClassificationJobsRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly
            ] = proxy(ListClassificationJobsPaginated, request)
            def updateAutomatedDiscoveryConfiguration(
                request: UpdateAutomatedDiscoveryConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.UpdateAutomatedDiscoveryConfigurationResponse.ReadOnly
            ] = proxy(UpdateAutomatedDiscoveryConfiguration, request)
            def disableOrganizationAdminAccount(
                request: DisableOrganizationAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.DisableOrganizationAdminAccountResponse.ReadOnly
            ] = proxy(DisableOrganizationAdminAccount, request)
            def listAutomatedDiscoveryAccounts(
                request: ListAutomatedDiscoveryAccountsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.AutomatedDiscoveryAccount.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAutomatedDiscoveryAccounts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAutomatedDiscoveryAccountsPaginated(
                request: ListAutomatedDiscoveryAccountsRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListAutomatedDiscoveryAccountsResponse.ReadOnly
            ] = proxy(ListAutomatedDiscoveryAccountsPaginated, request)
            def listResourceProfileArtifacts(
                request: ListResourceProfileArtifactsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.ResourceProfileArtifact.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListResourceProfileArtifacts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listResourceProfileArtifactsPaginated(
                request: ListResourceProfileArtifactsRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListResourceProfileArtifactsResponse.ReadOnly
            ] = proxy(ListResourceProfileArtifactsPaginated, request)
            def createSampleFindings(request: CreateSampleFindingsRequest): IO[
              AwsError,
              zio.aws.macie2.model.CreateSampleFindingsResponse.ReadOnly
            ] = proxy(CreateSampleFindings, request)
            def getMacieSession(request: GetMacieSessionRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly
            ] = proxy(GetMacieSession, request)
            def createClassificationJob(
                request: CreateClassificationJobRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.CreateClassificationJobResponse.ReadOnly
            ] = proxy(CreateClassificationJob, request)
            def listOrganizationAdminAccounts(
                request: ListOrganizationAdminAccountsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.AdminAccount.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOrganizationAdminAccounts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOrganizationAdminAccountsPaginated(
                request: ListOrganizationAdminAccountsRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly
            ] = proxy(ListOrganizationAdminAccountsPaginated, request)
            def updateOrganizationConfiguration(
                request: UpdateOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.UpdateOrganizationConfigurationResponse.ReadOnly
            ] = proxy(UpdateOrganizationConfiguration, request)
            def updateResourceProfileDetections(
                request: UpdateResourceProfileDetectionsRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.UpdateResourceProfileDetectionsResponse.ReadOnly
            ] = proxy(UpdateResourceProfileDetections, request)
            def updateFindingsFilter(request: UpdateFindingsFilterRequest): IO[
              AwsError,
              zio.aws.macie2.model.UpdateFindingsFilterResponse.ReadOnly
            ] = proxy(UpdateFindingsFilter, request)
            def createMember(request: CreateMemberRequest): IO[
              AwsError,
              zio.aws.macie2.model.CreateMemberResponse.ReadOnly
            ] = proxy(CreateMember, request)
            def batchUpdateAutomatedDiscoveryAccounts(
                request: BatchUpdateAutomatedDiscoveryAccountsRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse.ReadOnly
            ] = proxy(BatchUpdateAutomatedDiscoveryAccounts, request)
            def putFindingsPublicationConfiguration(
                request: PutFindingsPublicationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.PutFindingsPublicationConfigurationResponse.ReadOnly
            ] = proxy(PutFindingsPublicationConfiguration, request)
            def getAutomatedDiscoveryConfiguration(
                request: GetAutomatedDiscoveryConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetAutomatedDiscoveryConfigurationResponse.ReadOnly
            ] = proxy(GetAutomatedDiscoveryConfiguration, request)
            def createInvitations(request: CreateInvitationsRequest): IO[
              AwsError,
              zio.aws.macie2.model.CreateInvitationsResponse.ReadOnly
            ] = proxy(CreateInvitations, request)
            def disassociateMember(request: DisassociateMemberRequest): IO[
              AwsError,
              zio.aws.macie2.model.DisassociateMemberResponse.ReadOnly
            ] = proxy(DisassociateMember, request)
            def listFindingsFilters(
                request: ListFindingsFiltersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.FindingsFilterListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFindingsFilters, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFindingsFiltersPaginated(
                request: ListFindingsFiltersRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListFindingsFiltersResponse.ReadOnly
            ] = proxy(ListFindingsFiltersPaginated, request)
            def getInvitationsCount(request: GetInvitationsCountRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetInvitationsCountResponse.ReadOnly
            ] = proxy(GetInvitationsCount, request)
            def createCustomDataIdentifier(
                request: CreateCustomDataIdentifierRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.CreateCustomDataIdentifierResponse.ReadOnly
            ] = proxy(CreateCustomDataIdentifier, request)
            def updateMacieSession(request: UpdateMacieSessionRequest): IO[
              AwsError,
              zio.aws.macie2.model.UpdateMacieSessionResponse.ReadOnly
            ] = proxy(UpdateMacieSession, request)
            def getSensitivityInspectionTemplate(
                request: GetSensitivityInspectionTemplateRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetSensitivityInspectionTemplateResponse.ReadOnly
            ] = proxy(GetSensitivityInspectionTemplate, request)
            def disassociateFromMasterAccount(
                request: DisassociateFromMasterAccountRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.DisassociateFromMasterAccountResponse.ReadOnly
            ] = proxy(DisassociateFromMasterAccount, request)
            def getResourceProfile(request: GetResourceProfileRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetResourceProfileResponse.ReadOnly
            ] = proxy(GetResourceProfile, request)
            def updateAllowList(request: UpdateAllowListRequest): IO[
              AwsError,
              zio.aws.macie2.model.UpdateAllowListResponse.ReadOnly
            ] = proxy(UpdateAllowList, request)
            def putClassificationExportConfiguration(
                request: PutClassificationExportConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.PutClassificationExportConfigurationResponse.ReadOnly
            ] = proxy(PutClassificationExportConfiguration, request)
            def listMembers(
                request: ListMembersRequest
            ): ZStream[Any, AwsError, zio.aws.macie2.model.Member.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListMembers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listMembersPaginated(
                request: ListMembersRequest
            ): IO[AwsError, zio.aws.macie2.model.ListMembersResponse.ReadOnly] =
              proxy(ListMembersPaginated, request)
            def updateResourceProfile(
                request: UpdateResourceProfileRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.UpdateResourceProfileResponse.ReadOnly
            ] = proxy(UpdateResourceProfile, request)
            def listManagedDataIdentifiers(
                request: ListManagedDataIdentifiersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListManagedDataIdentifiers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listManagedDataIdentifiersPaginated(
                request: ListManagedDataIdentifiersRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListManagedDataIdentifiersResponse.ReadOnly
            ] = proxy(ListManagedDataIdentifiersPaginated, request)
            def describeBuckets(request: DescribeBucketsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.BucketMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeBuckets, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeBucketsPaginated(request: DescribeBucketsRequest): IO[
              AwsError,
              zio.aws.macie2.model.DescribeBucketsResponse.ReadOnly
            ] = proxy(DescribeBucketsPaginated, request)
            def getAllowList(request: GetAllowListRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetAllowListResponse.ReadOnly
            ] = proxy(GetAllowList, request)
            def enableMacie(
                request: EnableMacieRequest
            ): IO[AwsError, zio.aws.macie2.model.EnableMacieResponse.ReadOnly] =
              proxy(EnableMacie, request)
            def getSensitiveDataOccurrencesAvailability(
                request: GetSensitiveDataOccurrencesAvailabilityRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.ReadOnly
            ] = proxy(GetSensitiveDataOccurrencesAvailability, request)
            def listResourceProfileDetections(
                request: ListResourceProfileDetectionsRequest
            ): ZStream[Any, AwsError, zio.aws.macie2.model.Detection.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListResourceProfileDetections, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listResourceProfileDetectionsPaginated(
                request: ListResourceProfileDetectionsRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListResourceProfileDetectionsResponse.ReadOnly
            ] = proxy(ListResourceProfileDetectionsPaginated, request)
            def getFindingStatistics(request: GetFindingStatisticsRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetFindingStatisticsResponse.ReadOnly
            ] = proxy(GetFindingStatistics, request)
            def listClassificationScopes(
                request: ListClassificationScopesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.ClassificationScopeSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListClassificationScopes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listClassificationScopesPaginated(
                request: ListClassificationScopesRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListClassificationScopesResponse.ReadOnly
            ] = proxy(ListClassificationScopesPaginated, request)
            def getRevealConfiguration(
                request: GetRevealConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetRevealConfigurationResponse.ReadOnly
            ] = proxy(GetRevealConfiguration, request)
            def deleteAllowList(request: DeleteAllowListRequest): IO[
              AwsError,
              zio.aws.macie2.model.DeleteAllowListResponse.ReadOnly
            ] = proxy(DeleteAllowList, request)
            def searchResources(request: SearchResourcesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.MatchingResource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchResources, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchResourcesPaginated(request: SearchResourcesRequest): IO[
              AwsError,
              zio.aws.macie2.model.SearchResourcesResponse.ReadOnly
            ] = proxy(SearchResourcesPaginated, request)
            def createAllowList(request: CreateAllowListRequest): IO[
              AwsError,
              zio.aws.macie2.model.CreateAllowListResponse.ReadOnly
            ] = proxy(CreateAllowList, request)
            def disableMacie(request: DisableMacieRequest): IO[
              AwsError,
              zio.aws.macie2.model.DisableMacieResponse.ReadOnly
            ] = proxy(DisableMacie, request)
            def getSensitiveDataOccurrences(
                request: GetSensitiveDataOccurrencesRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.ReadOnly
            ] = proxy(GetSensitiveDataOccurrences, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.macie2.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getClassificationScope(
                request: GetClassificationScopeRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetClassificationScopeResponse.ReadOnly
            ] = proxy(GetClassificationScope, request)
            def getFindings(
                request: GetFindingsRequest
            ): IO[AwsError, zio.aws.macie2.model.GetFindingsResponse.ReadOnly] =
              proxy(GetFindings, request)
            def getMember(
                request: GetMemberRequest
            ): IO[AwsError, zio.aws.macie2.model.GetMemberResponse.ReadOnly] =
              proxy(GetMember, request)
            def getCustomDataIdentifier(
                request: GetCustomDataIdentifierRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly
            ] = proxy(GetCustomDataIdentifier, request)
            def describeOrganizationConfiguration(
                request: DescribeOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.DescribeOrganizationConfigurationResponse.ReadOnly
            ] = proxy(DescribeOrganizationConfiguration, request)
            def listSensitivityInspectionTemplates(
                request: ListSensitivityInspectionTemplatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSensitivityInspectionTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSensitivityInspectionTemplatesPaginated(
                request: ListSensitivityInspectionTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListSensitivityInspectionTemplatesResponse.ReadOnly
            ] = proxy(ListSensitivityInspectionTemplatesPaginated, request)
            def acceptInvitation(request: AcceptInvitationRequest): IO[
              AwsError,
              zio.aws.macie2.model.AcceptInvitationResponse.ReadOnly
            ] = proxy(AcceptInvitation, request)
            def deleteMember(request: DeleteMemberRequest): IO[
              AwsError,
              zio.aws.macie2.model.DeleteMemberResponse.ReadOnly
            ] = proxy(DeleteMember, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.macie2.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getFindingsPublicationConfiguration(
                request: GetFindingsPublicationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetFindingsPublicationConfigurationResponse.ReadOnly
            ] = proxy(GetFindingsPublicationConfiguration, request)
            def getClassificationExportConfiguration(
                request: GetClassificationExportConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetClassificationExportConfigurationResponse.ReadOnly
            ] = proxy(GetClassificationExportConfiguration, request)
            def describeClassificationJob(
                request: DescribeClassificationJobRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly
            ] = proxy(DescribeClassificationJob, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.macie2.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def listInvitations(request: ListInvitationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.Invitation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInvitations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInvitationsPaginated(request: ListInvitationsRequest): IO[
              AwsError,
              zio.aws.macie2.model.ListInvitationsResponse.ReadOnly
            ] = proxy(ListInvitationsPaginated, request)
            def batchGetCustomDataIdentifiers(
                request: BatchGetCustomDataIdentifiersRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.BatchGetCustomDataIdentifiersResponse.ReadOnly
            ] = proxy(BatchGetCustomDataIdentifiers, request)
            def deleteFindingsFilter(request: DeleteFindingsFilterRequest): IO[
              AwsError,
              zio.aws.macie2.model.DeleteFindingsFilterResponse.ReadOnly
            ] = proxy(DeleteFindingsFilter, request)
            def getFindingsFilter(request: GetFindingsFilterRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetFindingsFilterResponse.ReadOnly
            ] = proxy(GetFindingsFilter, request)
            def declineInvitations(request: DeclineInvitationsRequest): IO[
              AwsError,
              zio.aws.macie2.model.DeclineInvitationsResponse.ReadOnly
            ] = proxy(DeclineInvitations, request)
            def getUsageTotals(request: GetUsageTotalsRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly
            ] = proxy(GetUsageTotals, request)
            def getBucketStatistics(request: GetBucketStatisticsRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly
            ] = proxy(GetBucketStatistics, request)
            def listAllowLists(request: ListAllowListsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.AllowListSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAllowLists, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAllowListsPaginated(request: ListAllowListsRequest): IO[
              AwsError,
              zio.aws.macie2.model.ListAllowListsResponse.ReadOnly
            ] = proxy(ListAllowListsPaginated, request)
            def updateSensitivityInspectionTemplate(
                request: UpdateSensitivityInspectionTemplateRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.UpdateSensitivityInspectionTemplateResponse.ReadOnly
            ] = proxy(UpdateSensitivityInspectionTemplate, request)
            def updateClassificationScope(
                request: UpdateClassificationScopeRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.UpdateClassificationScopeResponse.ReadOnly
            ] = proxy(UpdateClassificationScope, request)
            def createFindingsFilter(request: CreateFindingsFilterRequest): IO[
              AwsError,
              zio.aws.macie2.model.CreateFindingsFilterResponse.ReadOnly
            ] = proxy(CreateFindingsFilter, request)
            def enableOrganizationAdminAccount(
                request: EnableOrganizationAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.EnableOrganizationAdminAccountResponse.ReadOnly
            ] = proxy(EnableOrganizationAdminAccount, request)
            def getMasterAccount(request: GetMasterAccountRequest): IO[
              AwsError,
              zio.aws.macie2.model.GetMasterAccountResponse.ReadOnly
            ] = proxy(GetMasterAccount, request)
            def listCustomDataIdentifiers(
                request: ListCustomDataIdentifiersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCustomDataIdentifiers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCustomDataIdentifiersPaginated(
                request: ListCustomDataIdentifiersRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.ListCustomDataIdentifiersResponse.ReadOnly
            ] = proxy(ListCustomDataIdentifiersPaginated, request)
            def deleteInvitations(request: DeleteInvitationsRequest): IO[
              AwsError,
              zio.aws.macie2.model.DeleteInvitationsResponse.ReadOnly
            ] = proxy(DeleteInvitations, request)
            def updateClassificationJob(
                request: UpdateClassificationJobRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateClassificationJob, request)
            def testCustomDataIdentifier(
                request: TestCustomDataIdentifierRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.TestCustomDataIdentifierResponse.ReadOnly
            ] = proxy(TestCustomDataIdentifier, request)
            def updateRevealConfiguration(
                request: UpdateRevealConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.UpdateRevealConfigurationResponse.ReadOnly
            ] = proxy(UpdateRevealConfiguration, request)
            def deleteCustomDataIdentifier(
                request: DeleteCustomDataIdentifierRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.DeleteCustomDataIdentifierResponse.ReadOnly
            ] = proxy(DeleteCustomDataIdentifier, request)
            def disassociateFromAdministratorAccount(
                request: DisassociateFromAdministratorAccountRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.DisassociateFromAdministratorAccountResponse.ReadOnly
            ] = proxy(DisassociateFromAdministratorAccount, request)
            def getUsageStatistics(request: GetUsageStatisticsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.macie2.model.UsageRecord.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetUsageStatistics, request)
                }
                .getOrThrowFiberFailure()
            }
            def getUsageStatisticsPaginated(
                request: GetUsageStatisticsRequest
            ): IO[
              AwsError,
              zio.aws.macie2.model.GetUsageStatisticsResponse.ReadOnly
            ] = proxy(GetUsageStatisticsPaginated, request)
            def updateMemberSession(request: UpdateMemberSessionRequest): IO[
              AwsError,
              zio.aws.macie2.model.UpdateMemberSessionResponse.ReadOnly
            ] = proxy(UpdateMemberSession, request)
          }
        }
      }
    }
  }
}
