package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AcceptInvitationRequest(
    administratorAccountId: Optional[__string] = Optional.Absent,
    invitationId: __string,
    masterAccount: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest = {
    import AcceptInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest
      .builder()
      .optionallyWith(
        administratorAccountId.map(value => value: java.lang.String)
      )(_.administratorAccountId)
      .invitationId(invitationId: java.lang.String)
      .optionallyWith(masterAccount.map(value => value: java.lang.String))(
        _.masterAccount
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AcceptInvitationRequest.ReadOnly =
    zio.aws.macie2.model.AcceptInvitationRequest.wrap(buildAwsValue())
}
object AcceptInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AcceptInvitationRequest =
      zio.aws.macie2.model.AcceptInvitationRequest(
        administratorAccountId.map(value => value),
        invitationId,
        masterAccount.map(value => value)
      )
    def administratorAccountId: Optional[__string]
    def invitationId: __string
    def masterAccount: Optional[__string]
    def getAdministratorAccountId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("administratorAccountId", administratorAccountId)
    def getInvitationId: ZIO[Any, Nothing, __string] = ZIO.succeed(invitationId)
    def getMasterAccount: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("masterAccount", masterAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest
  ) extends zio.aws.macie2.model.AcceptInvitationRequest.ReadOnly {
    override val administratorAccountId: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administratorAccountId())
        .map(value => value: __string)
    override val invitationId: __string = impl.invitationId(): __string
    override val masterAccount: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.masterAccount())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest
  ): zio.aws.macie2.model.AcceptInvitationRequest.ReadOnly = new Wrapper(impl)
}
