package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait AdminStatus {
  def unwrap: software.amazon.awssdk.services.macie2.model.AdminStatus
}
object AdminStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.AdminStatus
  ): zio.aws.macie2.model.AdminStatus = value match {
    case software.amazon.awssdk.services.macie2.model.AdminStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.AdminStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.macie2.model.AdminStatus.DISABLING_IN_PROGRESS =>
      val r = DISABLING_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.AdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AdminStatus =
      software.amazon.awssdk.services.macie2.model.AdminStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.macie2.model.AdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AdminStatus =
      software.amazon.awssdk.services.macie2.model.AdminStatus.ENABLED
  }
  case object DISABLING_IN_PROGRESS extends zio.aws.macie2.model.AdminStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AdminStatus =
      software.amazon.awssdk.services.macie2.model.AdminStatus.DISABLING_IN_PROGRESS
  }
}
