package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__stringMin1Max1024PatternSS
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AllowListStatus(
    code: zio.aws.macie2.model.AllowListStatusCode,
    description: Optional[__stringMin1Max1024PatternSS] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AllowListStatus = {
    import AllowListStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AllowListStatus
      .builder()
      .code(code.unwrap)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AllowListStatus.ReadOnly =
    zio.aws.macie2.model.AllowListStatus.wrap(buildAwsValue())
}
object AllowListStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AllowListStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AllowListStatus = zio.aws.macie2.model
      .AllowListStatus(code, description.map(value => value))
    def code: zio.aws.macie2.model.AllowListStatusCode
    def description: Optional[__stringMin1Max1024PatternSS]
    def getCode: ZIO[Any, Nothing, zio.aws.macie2.model.AllowListStatusCode] =
      ZIO.succeed(code)
    def getDescription: ZIO[Any, AwsError, __stringMin1Max1024PatternSS] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AllowListStatus
  ) extends zio.aws.macie2.model.AllowListStatus.ReadOnly {
    override val code: zio.aws.macie2.model.AllowListStatusCode =
      zio.aws.macie2.model.AllowListStatusCode.wrap(impl.code())
    override val description: Optional[__stringMin1Max1024PatternSS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => value: __stringMin1Max1024PatternSS)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AllowListStatus
  ): zio.aws.macie2.model.AllowListStatus.ReadOnly = new Wrapper(impl)
}
