package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait AutoEnableMode {
  def unwrap: software.amazon.awssdk.services.macie2.model.AutoEnableMode
}
object AutoEnableMode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.AutoEnableMode
  ): zio.aws.macie2.model.AutoEnableMode = value match {
    case software.amazon.awssdk.services.macie2.model.AutoEnableMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.AutoEnableMode.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.macie2.model.AutoEnableMode.NEW =>
      val r = NEW
      r
    case software.amazon.awssdk.services.macie2.model.AutoEnableMode.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.AutoEnableMode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutoEnableMode =
      software.amazon.awssdk.services.macie2.model.AutoEnableMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.macie2.model.AutoEnableMode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutoEnableMode =
      software.amazon.awssdk.services.macie2.model.AutoEnableMode.ALL
  }
  case object NEW extends zio.aws.macie2.model.AutoEnableMode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutoEnableMode =
      software.amazon.awssdk.services.macie2.model.AutoEnableMode.NEW
  }
  case object NONE extends zio.aws.macie2.model.AutoEnableMode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutoEnableMode =
      software.amazon.awssdk.services.macie2.model.AutoEnableMode.NONE
  }
}
