package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait AutomatedDiscoveryAccountStatus {
  def unwrap: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus
}
object AutomatedDiscoveryAccountStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus
  ): zio.aws.macie2.model.AutomatedDiscoveryAccountStatus = value match {
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.AutomatedDiscoveryAccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.macie2.model.AutomatedDiscoveryAccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus.ENABLED
  }
  case object DISABLED
      extends zio.aws.macie2.model.AutomatedDiscoveryAccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountStatus.DISABLED
  }
}
