package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutomatedDiscoveryAccountUpdateError(
    accountId: Optional[__string] = Optional.Absent,
    errorCode: Optional[
      zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateError = {
    import AutomatedDiscoveryAccountUpdateError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateError
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError.ReadOnly =
    zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError
      .wrap(buildAwsValue())
}
object AutomatedDiscoveryAccountUpdateError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError =
      zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError(
        accountId.map(value => value),
        errorCode.map(value => value)
      )
    def accountId: Optional[__string]
    def errorCode: Optional[
      zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode
    ]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateError
  ) extends zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val errorCode: Optional[
      zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value =>
        zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateError
  ): zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError.ReadOnly =
    new Wrapper(impl)
}
