package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait AutomatedDiscoveryAccountUpdateErrorCode {
  def unwrap: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode
}
object AutomatedDiscoveryAccountUpdateErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode
  ): zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode =
    value match {
      case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode.ACCOUNT_PAUSED =>
        val r = ACCOUNT_PAUSED
        r
      case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode.ACCOUNT_NOT_FOUND =>
        val r = ACCOUNT_NOT_FOUND
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT_PAUSED
      extends zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode.ACCOUNT_PAUSED
  }
  case object ACCOUNT_NOT_FOUND
      extends zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdateErrorCode.ACCOUNT_NOT_FOUND
  }
}
