package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait AutomatedDiscoveryMonitoringStatus {
  def unwrap: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus
}
object AutomatedDiscoveryMonitoringStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus
  ): zio.aws.macie2.model.AutomatedDiscoveryMonitoringStatus = value match {
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus.MONITORED =>
      val r = MONITORED
      r
    case software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus.NOT_MONITORED =>
      val r = NOT_MONITORED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.AutomatedDiscoveryMonitoringStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object MONITORED
      extends zio.aws.macie2.model.AutomatedDiscoveryMonitoringStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus.MONITORED
  }
  case object NOT_MONITORED
      extends zio.aws.macie2.model.AutomatedDiscoveryMonitoringStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus =
      software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryMonitoringStatus.NOT_MONITORED
  }
}
