package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchUpdateAutomatedDiscoveryAccountsRequest(
    accounts: Optional[
      Iterable[zio.aws.macie2.model.AutomatedDiscoveryAccountUpdate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest = {
    import BatchUpdateAutomatedDiscoveryAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accounts)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest.ReadOnly =
    zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest
      .wrap(buildAwsValue())
}
object BatchUpdateAutomatedDiscoveryAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest =
      zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest(
        accounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accounts: Optional[
      List[zio.aws.macie2.model.AutomatedDiscoveryAccountUpdate.ReadOnly]
    ]
    def getAccounts: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.AutomatedDiscoveryAccountUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("accounts", accounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest
  ) extends zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest.ReadOnly {
    override val accounts: Optional[
      List[zio.aws.macie2.model.AutomatedDiscoveryAccountUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.AutomatedDiscoveryAccountUpdate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest
  ): zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsRequest.ReadOnly =
    new Wrapper(impl)
}
