package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchUpdateAutomatedDiscoveryAccountsResponse(
    errors: Optional[
      Iterable[zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse = {
    import BatchUpdateAutomatedDiscoveryAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse.ReadOnly =
    zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse
      .wrap(buildAwsValue())
}
object BatchUpdateAutomatedDiscoveryAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse =
      zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[
      List[zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError.ReadOnly]
    ]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse
  ) extends zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse.ReadOnly {
    override val errors: Optional[
      List[zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.AutomatedDiscoveryAccountUpdateError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse
  ): zio.aws.macie2.model.BatchUpdateAutomatedDiscoveryAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
