package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BucketPublicAccess(
    effectivePermission: Optional[zio.aws.macie2.model.EffectivePermission] =
      Optional.Absent,
    permissionConfiguration: Optional[
      zio.aws.macie2.model.BucketPermissionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketPublicAccess = {
    import BucketPublicAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketPublicAccess
      .builder()
      .optionallyWith(effectivePermission.map(value => value.unwrap))(
        _.effectivePermission
      )
      .optionallyWith(
        permissionConfiguration.map(value => value.buildAwsValue())
      )(_.permissionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketPublicAccess.ReadOnly =
    zio.aws.macie2.model.BucketPublicAccess.wrap(buildAwsValue())
}
object BucketPublicAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketPublicAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketPublicAccess =
      zio.aws.macie2.model.BucketPublicAccess(
        effectivePermission.map(value => value),
        permissionConfiguration.map(value => value.asEditable)
      )
    def effectivePermission: Optional[zio.aws.macie2.model.EffectivePermission]
    def permissionConfiguration
        : Optional[zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly]
    def getEffectivePermission
        : ZIO[Any, AwsError, zio.aws.macie2.model.EffectivePermission] =
      AwsError.unwrapOptionField("effectivePermission", effectivePermission)
    def getPermissionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "permissionConfiguration",
      permissionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketPublicAccess
  ) extends zio.aws.macie2.model.BucketPublicAccess.ReadOnly {
    override val effectivePermission
        : Optional[zio.aws.macie2.model.EffectivePermission] =
      zio.aws.core.internal
        .optionalFromNullable(impl.effectivePermission())
        .map(value => zio.aws.macie2.model.EffectivePermission.wrap(value))
    override val permissionConfiguration: Optional[
      zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionConfiguration())
      .map(value =>
        zio.aws.macie2.model.BucketPermissionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketPublicAccess
  ): zio.aws.macie2.model.BucketPublicAccess.ReadOnly = new Wrapper(impl)
}
