package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BucketStatisticsBySensitivity(
    classificationError: Optional[
      zio.aws.macie2.model.SensitivityAggregations
    ] = Optional.Absent,
    notClassified: Optional[zio.aws.macie2.model.SensitivityAggregations] =
      Optional.Absent,
    notSensitive: Optional[zio.aws.macie2.model.SensitivityAggregations] =
      Optional.Absent,
    sensitive: Optional[zio.aws.macie2.model.SensitivityAggregations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketStatisticsBySensitivity = {
    import BucketStatisticsBySensitivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketStatisticsBySensitivity
      .builder()
      .optionallyWith(classificationError.map(value => value.buildAwsValue()))(
        _.classificationError
      )
      .optionallyWith(notClassified.map(value => value.buildAwsValue()))(
        _.notClassified
      )
      .optionallyWith(notSensitive.map(value => value.buildAwsValue()))(
        _.notSensitive
      )
      .optionallyWith(sensitive.map(value => value.buildAwsValue()))(
        _.sensitive
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketStatisticsBySensitivity.ReadOnly =
    zio.aws.macie2.model.BucketStatisticsBySensitivity.wrap(buildAwsValue())
}
object BucketStatisticsBySensitivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketStatisticsBySensitivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketStatisticsBySensitivity =
      zio.aws.macie2.model.BucketStatisticsBySensitivity(
        classificationError.map(value => value.asEditable),
        notClassified.map(value => value.asEditable),
        notSensitive.map(value => value.asEditable),
        sensitive.map(value => value.asEditable)
      )
    def classificationError
        : Optional[zio.aws.macie2.model.SensitivityAggregations.ReadOnly]
    def notClassified
        : Optional[zio.aws.macie2.model.SensitivityAggregations.ReadOnly]
    def notSensitive
        : Optional[zio.aws.macie2.model.SensitivityAggregations.ReadOnly]
    def sensitive
        : Optional[zio.aws.macie2.model.SensitivityAggregations.ReadOnly]
    def getClassificationError: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SensitivityAggregations.ReadOnly
    ] = AwsError.unwrapOptionField("classificationError", classificationError)
    def getNotClassified: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SensitivityAggregations.ReadOnly
    ] = AwsError.unwrapOptionField("notClassified", notClassified)
    def getNotSensitive: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SensitivityAggregations.ReadOnly
    ] = AwsError.unwrapOptionField("notSensitive", notSensitive)
    def getSensitive: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SensitivityAggregations.ReadOnly
    ] = AwsError.unwrapOptionField("sensitive", sensitive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketStatisticsBySensitivity
  ) extends zio.aws.macie2.model.BucketStatisticsBySensitivity.ReadOnly {
    override val classificationError
        : Optional[zio.aws.macie2.model.SensitivityAggregations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classificationError())
        .map(value => zio.aws.macie2.model.SensitivityAggregations.wrap(value))
    override val notClassified
        : Optional[zio.aws.macie2.model.SensitivityAggregations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notClassified())
        .map(value => zio.aws.macie2.model.SensitivityAggregations.wrap(value))
    override val notSensitive
        : Optional[zio.aws.macie2.model.SensitivityAggregations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notSensitive())
        .map(value => zio.aws.macie2.model.SensitivityAggregations.wrap(value))
    override val sensitive
        : Optional[zio.aws.macie2.model.SensitivityAggregations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sensitive())
        .map(value => zio.aws.macie2.model.SensitivityAggregations.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketStatisticsBySensitivity
  ): zio.aws.macie2.model.BucketStatisticsBySensitivity.ReadOnly = new Wrapper(
    impl
  )
}
