package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateInvitationsRequest(
    accountIds: Iterable[__string],
    disableEmailNotification: Optional[__boolean] = Optional.Absent,
    message: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest = {
    import CreateInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest
      .builder()
      .accountIds(accountIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        disableEmailNotification.map(value => value: java.lang.Boolean)
      )(_.disableEmailNotification)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateInvitationsRequest.ReadOnly =
    zio.aws.macie2.model.CreateInvitationsRequest.wrap(buildAwsValue())
}
object CreateInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateInvitationsRequest =
      zio.aws.macie2.model.CreateInvitationsRequest(
        accountIds,
        disableEmailNotification.map(value => value),
        message.map(value => value)
      )
    def accountIds: List[__string]
    def disableEmailNotification: Optional[__boolean]
    def message: Optional[__string]
    def getAccountIds: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(accountIds)
    def getDisableEmailNotification: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableEmailNotification", disableEmailNotification)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest
  ) extends zio.aws.macie2.model.CreateInvitationsRequest.ReadOnly {
    override val accountIds: List[__string] = impl
      .accountIds()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val disableEmailNotification: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableEmailNotification())
        .map(value => value: __boolean)
    override val message: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest
  ): zio.aws.macie2.model.CreateInvitationsRequest.ReadOnly = new Wrapper(impl)
}
