package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateInvitationsResponse(
    unprocessedAccounts: Optional[
      Iterable[zio.aws.macie2.model.UnprocessedAccount]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse = {
    import CreateInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse
      .builder()
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateInvitationsResponse.ReadOnly =
    zio.aws.macie2.model.CreateInvitationsResponse.wrap(buildAwsValue())
}
object CreateInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateInvitationsResponse =
      zio.aws.macie2.model.CreateInvitationsResponse(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedAccounts
        : Optional[List[zio.aws.macie2.model.UnprocessedAccount.ReadOnly]]
    def getUnprocessedAccounts: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.UnprocessedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse
  ) extends zio.aws.macie2.model.CreateInvitationsResponse.ReadOnly {
    override val unprocessedAccounts
        : Optional[List[zio.aws.macie2.model.UnprocessedAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.UnprocessedAccount.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse
  ): zio.aws.macie2.model.CreateInvitationsResponse.ReadOnly = new Wrapper(impl)
}
