package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CustomDataIdentifierSummary(
    arn: Optional[__string] = Optional.Absent,
    createdAt: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    name: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary = {
    import CustomDataIdentifierSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly =
    zio.aws.macie2.model.CustomDataIdentifierSummary.wrap(buildAwsValue())
}
object CustomDataIdentifierSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CustomDataIdentifierSummary =
      zio.aws.macie2.model.CustomDataIdentifierSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[__string]
    def createdAt: Optional[__timestampIso8601]
    def description: Optional[__string]
    def id: Optional[__string]
    def name: Optional[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary
  ) extends zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val createdAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __timestampIso8601)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CustomDataIdentifierSummary
  ): zio.aws.macie2.model.CustomDataIdentifierSummary.ReadOnly = new Wrapper(
    impl
  )
}
