package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomDataIdentifiers(
    detections: Optional[Iterable[zio.aws.macie2.model.CustomDetection]] =
      Optional.Absent,
    totalCount: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers = {
    import CustomDataIdentifiers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers
      .builder()
      .optionallyWith(
        detections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detections)
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly =
    zio.aws.macie2.model.CustomDataIdentifiers.wrap(buildAwsValue())
}
object CustomDataIdentifiers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CustomDataIdentifiers =
      zio.aws.macie2.model.CustomDataIdentifiers(
        detections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalCount.map(value => value)
      )
    def detections
        : Optional[List[zio.aws.macie2.model.CustomDetection.ReadOnly]]
    def totalCount: Optional[__long]
    def getDetections: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.CustomDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("detections", detections)
    def getTotalCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers
  ) extends zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly {
    override val detections
        : Optional[List[zio.aws.macie2.model.CustomDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.CustomDetection.wrap(item)
          }.toList
        )
    override val totalCount: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CustomDataIdentifiers
  ): zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly = new Wrapper(impl)
}
