package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait DataIdentifierType {
  def unwrap: software.amazon.awssdk.services.macie2.model.DataIdentifierType
}
object DataIdentifierType {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.DataIdentifierType
  ): zio.aws.macie2.model.DataIdentifierType = value match {
    case software.amazon.awssdk.services.macie2.model.DataIdentifierType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.DataIdentifierType.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.macie2.model.DataIdentifierType.MANAGED =>
      val r = MANAGED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.DataIdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DataIdentifierType =
      software.amazon.awssdk.services.macie2.model.DataIdentifierType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOM extends zio.aws.macie2.model.DataIdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DataIdentifierType =
      software.amazon.awssdk.services.macie2.model.DataIdentifierType.CUSTOM
  }
  case object MANAGED extends zio.aws.macie2.model.DataIdentifierType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DataIdentifierType =
      software.amazon.awssdk.services.macie2.model.DataIdentifierType.MANAGED
  }
}
