package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait DayOfWeek {
  def unwrap: software.amazon.awssdk.services.macie2.model.DayOfWeek
}
object DayOfWeek {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.DayOfWeek
  ): zio.aws.macie2.model.DayOfWeek = value match {
    case software.amazon.awssdk.services.macie2.model.DayOfWeek.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.DayOfWeek.SUNDAY =>
      val r = SUNDAY
      r
    case software.amazon.awssdk.services.macie2.model.DayOfWeek.MONDAY =>
      val r = MONDAY
      r
    case software.amazon.awssdk.services.macie2.model.DayOfWeek.TUESDAY =>
      val r = TUESDAY
      r
    case software.amazon.awssdk.services.macie2.model.DayOfWeek.WEDNESDAY =>
      val r = WEDNESDAY
      r
    case software.amazon.awssdk.services.macie2.model.DayOfWeek.THURSDAY =>
      val r = THURSDAY
      r
    case software.amazon.awssdk.services.macie2.model.DayOfWeek.FRIDAY =>
      val r = FRIDAY
      r
    case software.amazon.awssdk.services.macie2.model.DayOfWeek.SATURDAY =>
      val r = SATURDAY
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DayOfWeek =
      software.amazon.awssdk.services.macie2.model.DayOfWeek.UNKNOWN_TO_SDK_VERSION
  }
  case object SUNDAY extends zio.aws.macie2.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DayOfWeek =
      software.amazon.awssdk.services.macie2.model.DayOfWeek.SUNDAY
  }
  case object MONDAY extends zio.aws.macie2.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DayOfWeek =
      software.amazon.awssdk.services.macie2.model.DayOfWeek.MONDAY
  }
  case object TUESDAY extends zio.aws.macie2.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DayOfWeek =
      software.amazon.awssdk.services.macie2.model.DayOfWeek.TUESDAY
  }
  case object WEDNESDAY extends zio.aws.macie2.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DayOfWeek =
      software.amazon.awssdk.services.macie2.model.DayOfWeek.WEDNESDAY
  }
  case object THURSDAY extends zio.aws.macie2.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DayOfWeek =
      software.amazon.awssdk.services.macie2.model.DayOfWeek.THURSDAY
  }
  case object FRIDAY extends zio.aws.macie2.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DayOfWeek =
      software.amazon.awssdk.services.macie2.model.DayOfWeek.FRIDAY
  }
  case object SATURDAY extends zio.aws.macie2.model.DayOfWeek {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.DayOfWeek =
      software.amazon.awssdk.services.macie2.model.DayOfWeek.SATURDAY
  }
}
