package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__boolean, __long, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Detection(
    arn: Optional[__string] = Optional.Absent,
    count: Optional[__long] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    suppressed: Optional[__boolean] = Optional.Absent,
    `type`: Optional[zio.aws.macie2.model.DataIdentifierType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.Detection = {
    import Detection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Detection
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(suppressed.map(value => value: java.lang.Boolean))(
        _.suppressed
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Detection.ReadOnly =
    zio.aws.macie2.model.Detection.wrap(buildAwsValue())
}
object Detection {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Detection] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Detection =
      zio.aws.macie2.model.Detection(
        arn.map(value => value),
        count.map(value => value),
        id.map(value => value),
        name.map(value => value),
        suppressed.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[__string]
    def count: Optional[__long]
    def id: Optional[__string]
    def name: Optional[__string]
    def suppressed: Optional[__boolean]
    def `type`: Optional[zio.aws.macie2.model.DataIdentifierType]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("count", count)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSuppressed: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("suppressed", suppressed)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.DataIdentifierType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Detection
  ) extends zio.aws.macie2.model.Detection.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val count: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: __long)
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val suppressed: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.suppressed())
      .map(value => value: __boolean)
    override val `type`: Optional[zio.aws.macie2.model.DataIdentifierType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.macie2.model.DataIdentifierType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Detection
  ): zio.aws.macie2.model.Detection.ReadOnly = new Wrapper(impl)
}
